/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.framework;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import org.jboss.osgi.spi.framework.OSGiConfigurationProvider;
import org.jboss.osgi.spi.framework.OSGiFramework;

public final class OSGiConfiguration {
    private OSGiConfiguration() {
    }

    public static OSGiFramework getFramework() {
        return OSGiConfiguration.getConfigurationProvider().getFramework();
    }

    public static OSGiFramework getFramework(String frameworkName) {
        return OSGiConfiguration.getConfigurationProvider().getFramework(frameworkName);
    }

    public static OSGiConfigurationProvider getConfigurationProvider() {
        OSGiConfigurationProvider provider;
        ClassLoader ctxLoader;
        String providerName = System.getProperty(OSGiConfigurationProvider.class.getName());
        if (providerName == null) {
            ctxLoader = Thread.currentThread().getContextClassLoader();
            URL providerURL = ctxLoader.getResource(OSGiConfigurationProvider.class.getName());
            if (providerURL == null) {
                throw new IllegalStateException("Cannot find resource: " + OSGiConfigurationProvider.class.getName());
            }
            try {
                providerName = new BufferedReader(new InputStreamReader(providerURL.openStream())).readLine();
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot read configuration provider name from: " + providerURL);
            }
        }
        if (providerName == null) {
            throw new IllegalStateException("Cannot obtain configuration provider");
        }
        try {
            ctxLoader = Thread.currentThread().getContextClassLoader();
            Class<?> providerClass = ctxLoader.loadClass(providerName);
            provider = (OSGiConfigurationProvider)providerClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot load configuration provider: " + providerName);
        }
        return provider;
    }
}

