/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.deployer;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleRealDeployer
extends AbstractSimpleRealDeployer<Deployment> {
    private BundleContext systemContext;
    private List<URL> skipBundles = new ArrayList<URL>();

    public BundleRealDeployer() {
        super(Deployment.class);
        this.addOutput(Bundle.class);
        this.setStage(DeploymentStages.POST_PARSE);
    }

    public void setSystemContext(BundleContext bundleContext) {
        this.systemContext = bundleContext;
    }

    public void setSkipBundles(List<URL> skipBundles) {
        this.skipBundles = skipBundles;
    }

    public void deploy(DeploymentUnit unit, Deployment dep) throws DeploymentException {
        VirtualFile rootFile = dep.getRoot();
        if (rootFile == null) {
            throw new IllegalStateException("Cannot obtain root file for: " + dep);
        }
        String path = rootFile.getPathName();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        boolean skipBundle = false;
        for (URL skip : this.skipBundles) {
            String skipPath = skip.getPath();
            if (!skipPath.equals(path)) continue;
            skipBundle = true;
            break;
        }
        if (skipBundle) {
            return;
        }
        try {
            String location = rootFile.toURL().toExternalForm();
            InputStream instream = rootFile.getStreamURL().openStream();
            Bundle bundle = this.systemContext.installBundle(location, instream);
            unit.addAttachment(Bundle.class, (Object)bundle);
            this.log.info((Object)("Installed: " + bundle));
        }
        catch (Exception ex) {
            throw DeploymentException.rethrowAsDeploymentException((String)("Cannot install bundle: " + dep), (Throwable)ex);
        }
    }

    public void undeploy(DeploymentUnit unit, Deployment dep) {
        Bundle bundle = (Bundle)unit.getAttachment(Bundle.class);
        if (bundle != null) {
            try {
                bundle.uninstall();
                this.log.info((Object)("Uninstalled: " + bundle));
            }
            catch (BundleException ex) {
                this.log.warn((Object)ex);
            }
        }
    }
}

