/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.deployer.helpers;

import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.Controller;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

/**
 * This dependency item uses the OSGi PackageAdmin to trigger a bundle resolve attempt.
 *
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 * @author Thomas.Diesler@jboss.com
 * @since 04-Mar-2009
 */
public class PackageAdminDependencyItem extends AbstractDependencyItem
{
   private static final ControllerState CTRL_STATE = ControllerState.getInstance(DeploymentStages.CLASSLOADER.getName());
   private final PackageAdmin packageAdmin;
   private final Bundle bundle;

   public PackageAdminDependencyItem(BundleContext systemContext, Bundle bundle)
   {
      super(bundle.getSymbolicName(), null, CTRL_STATE, null);

      this.bundle = bundle;

      ServiceReference sref = systemContext.getServiceReference(PackageAdmin.class.getName());
      packageAdmin = (PackageAdmin)systemContext.getService(sref);
      if (packageAdmin == null)
         throw new IllegalStateException("Cannot obtain PackageAdmin service");
   }

   @Override
   public boolean resolve(Controller controller)
   {
      if (packageAdmin.resolveBundles(new Bundle[] { bundle }))
         setResolved(true);
      
      return isResolved();
   }

   @Override
   protected void toHumanReadableString(StringBuilder builder)
   {
      builder.append("Bundle: ").append(bundle);
   }
}