/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.deployer;

import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractParsingDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentFactory;
import org.jboss.osgi.spi.util.BundleInfo;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;

public class BundleManifestParsingDeployer
extends AbstractParsingDeployer {
    public void deploy(DeploymentUnit unit) throws DeploymentException {
        Deployment dep = (Deployment)unit.getAttachment(Deployment.class);
        if (dep != null) {
            return;
        }
        if (!(unit instanceof VFSDeploymentUnit)) {
            return;
        }
        VirtualFile root = ((VFSDeploymentUnit)unit).getRoot();
        String symbolicName = null;
        try {
            Manifest manifest = VFSUtils.getManifest((VirtualFile)root);
            if (manifest == null) {
                return;
            }
            Attributes attribs = manifest.getMainAttributes();
            symbolicName = attribs.getValue("Bundle-SymbolicName");
        }
        catch (IOException e) {
            // empty catch block
        }
        if (symbolicName == null) {
            return;
        }
        try {
            BundleInfo info = BundleInfo.createBundleInfo((org.jboss.osgi.vfs.VirtualFile)AbstractVFS.adapt((Object)root));
            dep = DeploymentFactory.createDeployment((BundleInfo)info);
            unit.addAttachment(Deployment.class, (Object)dep);
            dep.setAutoStart(true);
        }
        catch (Exception ex) {
            // empty catch block
        }
    }
}

