/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.jta.internal;

//$Id: TransactionServiceActivator.java 95892 2009-11-01 12:22:13Z thomas.diesler@jboss.com $

import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

import org.jboss.osgi.jta.TransactionCapabilityMarker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

/**
 * A transaction services activator
 * 
 * @author thomas.diesler@jboss.com
 * @since 27-Oct-2009
 */
public class TransactionServiceActivator implements BundleActivator
{
   private ServiceRegistration userTransactionReg;
   private ServiceRegistration transactionManagerReg;
   
   public void start(BundleContext context)
   {
      // Always register the marker service
      TransactionCapabilityMarker markerService = new TransactionCapabilityMarker(){};
      context.registerService(TransactionCapabilityMarker.class.getName(), markerService, null);
      
      ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
      try
      {
         Thread.currentThread().setContextClassLoader(getClass().getClassLoader());
         
         // Register the TransactionManager service if is not already available
         // which would be the case for jbossas integration
         if (context.getServiceReference(TransactionManager.class.getName()) == null)
         {
            TransactionManager tm = com.arjuna.ats.jta.TransactionManager.transactionManager();
            transactionManagerReg = context.registerService(TransactionManager.class.getName(), tm, null);
         }
         
         // Register the UserTransaction service if is not already available
         // which would be the case for jbossas integration
         if (context.getServiceReference(UserTransaction.class.getName()) == null)
         {
            ServiceFactory txFactory = new UserTransactionServiceFactory();
            userTransactionReg = context.registerService(UserTransaction.class.getName(), txFactory, null);
         }
      }
      finally
      {
         Thread.currentThread().setContextClassLoader(ctxLoader);
      }
   }

   public void stop(BundleContext context)
   {
      if (userTransactionReg != null)
      {
         userTransactionReg.unregister();
         userTransactionReg = null;
      }
      
      if (transactionManagerReg != null)
      {
         transactionManagerReg.unregister();
         transactionManagerReg = null;
      }
   }
}