/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.service.hotdeploy.internal;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jboss.osgi.common.log.LogServiceTracker;
import org.jboss.osgi.service.hotdeploy.internal.BundleInfoImpl;
import org.jboss.osgi.service.hotdeploy.internal.ScannerThread;
import org.jboss.osgi.spi.service.BundleInfo;
import org.jboss.osgi.spi.service.DeployerService;
import org.jboss.osgi.spi.service.DeploymentScannerService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentScannerImpl
implements DeploymentScannerService {
    private LogServiceTracker log;
    private BundleContext context;
    private long scanInterval;
    private File scanLocation;
    private long scanCount;
    private long lastChange;
    private DeployerService deployer;
    private ScannerThread scannerThread;
    private List<BundleInfo> lastScan = new ArrayList<BundleInfo>();
    private Set<DeploymentScannerService.ScanListener> listeners = new LinkedHashSet<DeploymentScannerService.ScanListener>();
    private boolean traceBundles = false;

    public DeploymentScannerImpl(BundleContext context) {
        this.log = new LogServiceTracker(context);
        this.context = context;
        ServiceReference sref = context.getServiceReference(DeployerService.class.getName());
        this.deployer = (DeployerService)context.getService(sref);
        this.initScanner(context);
    }

    public long getScanCount() {
        return this.scanCount;
    }

    public long getScanInterval() {
        return this.scanInterval;
    }

    public URL getScanLocation() {
        return this.toURL(this.scanLocation.getAbsolutePath());
    }

    public long getLastChange() {
        return this.lastChange;
    }

    public void start() {
        String osgiHome = System.getProperty("osgi.home");
        String scandir = this.scanLocation.getAbsolutePath();
        if (scandir.startsWith(osgiHome)) {
            scandir = "..." + scandir.substring(osgiHome.length());
        }
        this.log.log(3, "Start DeploymentScanner: [scandir=" + scandir + ",interval=" + this.scanInterval + "ms]");
        this.scannerThread = new ScannerThread(this.context, this);
        this.lastChange = System.currentTimeMillis();
        this.scannerThread.start();
    }

    public void stop() {
        if (this.scannerThread != null) {
            this.log.log(3, "Stop DeploymentScanner");
            this.scannerThread.stopScan();
            this.scannerThread = null;
        }
    }

    public void addScanListener(DeploymentScannerService.ScanListener listener) {
        this.listeners.add(listener);
    }

    public void removeScanListener(DeploymentScannerService.ScanListener listener) {
        this.listeners.remove(listener);
    }

    public void scan() {
        int newDiff;
        int oldDiff;
        ArrayList<DeploymentScannerService.ScanListener> listenerArr = new ArrayList<DeploymentScannerService.ScanListener>(this.listeners);
        for (DeploymentScannerService.ScanListener listener : listenerArr) {
            listener.beforeScan((DeploymentScannerService)this);
        }
        List<BundleInfo> currScan = Arrays.asList(this.getBundles());
        if (this.traceBundles) {
            this.logBundleInfos("Current Scan", currScan);
        }
        if ((oldDiff = this.processOldDeployments(currScan)) + (newDiff = this.processNewDeployments(currScan)) > 0) {
            this.lastChange = System.currentTimeMillis();
        }
        this.lastScan = currScan;
        ++this.scanCount;
        for (DeploymentScannerService.ScanListener listener : listenerArr) {
            listener.afterScan((DeploymentScannerService)this);
        }
    }

    private void logBundleInfos(String message, List<BundleInfo> bundleInfos) {
        System.out.println(message);
        for (BundleInfo info : bundleInfos) {
            System.out.println("   " + info);
        }
    }

    private int processOldDeployments(List<BundleInfo> currScan) {
        ArrayList<BundleInfo> diff = new ArrayList<BundleInfo>();
        for (BundleInfo info : this.lastScan) {
            if (info.getState() != BundleInfo.State.INSTALLED && info.getState() != BundleInfo.State.ACTIVE || currScan.contains(info)) continue;
            diff.add(info);
        }
        if (this.traceBundles) {
            this.logBundleInfos("OLD diff", diff);
        }
        try {
            BundleInfo[] infoArr = diff.toArray(new BundleInfo[diff.size()]);
            this.deployer.undeploy(infoArr);
        }
        catch (Exception ex) {
            this.log.log(1, "Cannot undeploy bundles", (Throwable)ex);
        }
        return diff.size();
    }

    private int processNewDeployments(List<BundleInfo> currScan) {
        ArrayList<BundleInfo> diff = new ArrayList<BundleInfo>();
        for (BundleInfo info : currScan) {
            if (info.getState() != BundleInfo.State.NEW || this.lastScan.contains(info)) continue;
            diff.add(info);
        }
        if (this.traceBundles) {
            this.logBundleInfos("NEW diff", diff);
        }
        try {
            BundleInfo[] infoArr = diff.toArray(new BundleInfo[diff.size()]);
            this.deployer.deploy(infoArr);
        }
        catch (Exception ex) {
            this.log.log(1, "Cannot deploy bundles", (Throwable)ex);
        }
        return diff.size();
    }

    public BundleInfo[] getBundles() {
        ArrayList<BundleInfoImpl> bundles = new ArrayList<BundleInfoImpl>();
        for (File file : this.scanLocation.listFiles()) {
            BundleInfoImpl info = this.getBundleInfo(file);
            Bundle bundle = this.getInstalledBundle(info);
            if (bundle != null) {
                info.initFromBundle(bundle);
            }
            bundles.add(info);
        }
        BundleInfoImpl[] arr = new BundleInfoImpl[bundles.size()];
        return bundles.toArray(arr);
    }

    private void initScanner(BundleContext context) {
        String scanLoc;
        this.scanInterval = 2000L;
        String interval = context.getProperty("org.jboss.osgi.hotdeploy.interval");
        if (interval != null) {
            this.scanInterval = new Long(interval);
        }
        if ((scanLoc = context.getProperty("org.jboss.osgi.hotdeploy.scandir")) == null) {
            throw new IllegalStateException("Cannot obtain value for property: 'org.jboss.osgi.hotdeploy.scandir'");
        }
        try {
            URL scanURL = new URL(scanLoc);
            this.scanLocation = new File(scanURL.getPath());
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        File scanFile = new File(scanLoc);
        if (!scanFile.exists()) {
            throw new IllegalStateException("Scan location does not exist: " + scanLoc);
        }
        if (!scanFile.isDirectory()) {
            throw new IllegalStateException("Scan location is not a directory: " + scanLoc);
        }
        this.scanLocation = scanFile;
    }

    private BundleInfoImpl getBundleInfo(File file) {
        Manifest manifest;
        try {
            JarFile jarFile = new JarFile(file);
            manifest = jarFile.getManifest();
            jarFile.close();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot obtain manifest from: " + file, ex);
        }
        Attributes attribs = manifest.getMainAttributes();
        String symbolicName = attribs.getValue("Bundle-SymbolicName");
        if (symbolicName == null) {
            throw new IllegalStateException("Cannot obtain 'Bundle-SymbolicName' from: " + file);
        }
        String version = attribs.getValue("Bundle-Version");
        return new BundleInfoImpl(this.toURL(file), symbolicName, version);
    }

    private Bundle getInstalledBundle(BundleInfo info) {
        Bundle bundle = null;
        for (Bundle aux : this.context.getBundles()) {
            String name = aux.getSymbolicName();
            String version = (String)aux.getHeaders().get("Bundle-Version");
            if (version == null) {
                version = "0.0.0";
            }
            if (!name.equals(info.getSymbolicName()) || !version.equals(info.getVersion())) continue;
            bundle = aux;
            break;
        }
        return bundle;
    }

    private URL toURL(File file) {
        try {
            return file.toURL();
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Invalid URL: " + file);
        }
    }

    private URL toURL(String urlStr) {
        try {
            return new URL(urlStr);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Invalid URL: " + urlStr);
        }
    }
}

