/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.service.hotdeploy.internal;

import java.net.URL;
import java.util.Dictionary;
import org.jboss.osgi.spi.service.BundleInfo;
import org.osgi.framework.Bundle;

public class BundleInfoImpl
implements BundleInfo {
    private URL location;
    private String symbolicName;
    private String version;
    private BundleInfo.State state;

    public BundleInfoImpl(URL bundleURL, String symbolicName, String version) {
        this.symbolicName = symbolicName;
        this.location = bundleURL;
        this.state = BundleInfo.State.NEW;
        this.version = version != null ? version : "0.0.0";
    }

    public void initFromBundle(Bundle bundle) {
        Dictionary headers = bundle.getHeaders();
        String bundleVersion = (String)headers.get("Bundle-Version");
        if (bundleVersion != null) {
            this.version = bundleVersion;
        }
        int bundleState = bundle.getState();
        switch (bundleState) {
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                this.state = BundleInfo.State.INSTALLED;
                break;
            }
            case 32: {
                this.state = BundleInfo.State.ACTIVE;
                break;
            }
            case 1: {
                this.state = BundleInfo.State.UNINSTALLED;
            }
        }
    }

    public URL getLocation() {
        return this.location;
    }

    public BundleInfo.State getState() {
        return this.state;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BundleInfoImpl)) {
            return false;
        }
        BundleInfoImpl other = (BundleInfoImpl)obj;
        return this.symbolicName.equals(other.symbolicName) && this.version.equals(other.version);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "[" + this.state + "," + this.symbolicName + "," + this.version + "]";
    }
}

