/*
* JBoss, Home of Professional Open Source
Copyright 2009, Red Hat Middleware LLC, and individual contributors
* * by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.jmx.mbeanserver;

import javax.management.MBeanServer;


/**
 * MBeanServerChain.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 1.1 $
 */
public class MBeanServerChain extends DelegateMBeanServer
{
   /**
    * Create a new MBeanServerChain.
    * 
    * @param state
    */
   public MBeanServerChain(DelegateState state)
   {
      super(state);
      if (state.getOuter() == null)
         state.setOuter(this);
   }

   /**
    * Add as the first in the chain
    * 
    * @param server the server
    * @throws IllegalArgumentException for a null server
    * @throws SecurityException if not authorised
    */
   public void addFirst(DelegateMBeanServer server)
   {
      SecurityManager sm = System.getSecurityManager();
      if (sm != null)
         sm.checkPermission(new RuntimePermission(getClass().getName()));
         
      if (server == null)
         throw new IllegalArgumentException("Null server");
      
      server.setNext(getNext());
      setNext(server);
   }

   /**
    * Add as the last in the chain
    * 
    * @param server the server
    * @throws IllegalArgumentException for a null server
    * @throws SecurityException if not authorised
    */
   public void addLast(DelegateMBeanServer server)
   {
      SecurityManager sm = System.getSecurityManager();
      if (sm != null)
         sm.checkPermission(new RuntimePermission(getClass().getName()));

      if (server == null)
         throw new IllegalArgumentException("Null server");
      
      DelegateMBeanServer last = this;
      MBeanServer next = last.getNext();
      while (next instanceof DelegateMBeanServer)
      {
         last = (DelegateMBeanServer) next;
         next = last.getNext();
      }
      server.setNext(next);
      last.setNext(server);
   }

   /**
    * Set the target in the chain
    * 
    * @param server the server
    * @throws IllegalArgumentException for a null server
    * @throws IllegalStateException if the target is already set
    * @throws SecurityException if not authorised
    */
   public void setTarget(MBeanServer server)
   {
      SecurityManager sm = System.getSecurityManager();
      if (sm != null)
         sm.checkPermission(new RuntimePermission(getClass().getName()));

      if (server == null)
         throw new IllegalArgumentException("Null server");
      
      if (getNext() != null)
         throw new IllegalStateException("Target is already set");
      setNext(server);
   }
}
