package org.jboss.msc.service;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import java.lang.String;
import java.io.IOException;
import org.jboss.logging.Logger;
import java.lang.Exception;
import java.lang.Thread;
import org.jboss.msc.service.ServiceName;
import java.lang.Throwable;
import org.jboss.msc.service.StartException;
import java.lang.Object;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-09-11T11:51:07+0200")
public class ServiceLogger_$logger implements ServiceLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ServiceLogger_$logger.class.getName();
    public ServiceLogger_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void greeting(final String version) {
        log.logf(FQCN, INFO, null, greeting$str(), version);
    }
    private static final String greeting = "JBoss MSC version %s";
    protected String greeting$str() {
        return greeting;
    }
    @Override
    public final void startFailed(final org.jboss.msc.service.StartException cause, final org.jboss.msc.service.ServiceName serviceName) {
        log.logf(FQCN, ERROR, cause, startFailed$str(), serviceName);
    }
    private static final String startFailed = "MSC000001: Failed to start %s";
    protected String startFailed$str() {
        return startFailed;
    }
    @Override
    public final void listenerFailed(final Throwable cause, final Object listener) {
        log.logf(FQCN, ERROR, cause, listenerFailed$str(), listener);
    }
    private static final String listenerFailed = "MSC000002: Invocation of listener \"%s\" failed";
    protected String listenerFailed$str() {
        return listenerFailed;
    }
    @Override
    public final void exceptionAfterComplete(final Throwable cause, final org.jboss.msc.service.ServiceName serviceName) {
        log.logf(FQCN, WARN, cause, exceptionAfterComplete$str(), serviceName);
    }
    private static final String exceptionAfterComplete = "MSC000003: Exception thrown after start was already completed in %s";
    protected String exceptionAfterComplete$str() {
        return exceptionAfterComplete;
    }
    @Override
    public final void stopFailed(final Throwable cause, final org.jboss.msc.service.ServiceName serviceName) {
        log.logf(FQCN, WARN, cause, stopFailed$str(), serviceName);
    }
    private static final String stopFailed = "MSC000004: Failure during stop of %s";
    protected String stopFailed$str() {
        return stopFailed;
    }
    @Override
    public final void stopServiceMissing(final org.jboss.msc.service.ServiceName serviceName) {
        log.logf(FQCN, WARN, null, stopServiceMissing$str(), serviceName);
    }
    private static final String stopServiceMissing = "MSC000005: Unexpected disappearance of %s during stop";
    protected String stopServiceMissing$str() {
        return stopServiceMissing;
    }
    @Override
    public final void uninjectFailed(final Throwable cause, final org.jboss.msc.service.ServiceName serviceName, final ValueInjection<?> valueInjection) {
        log.logf(FQCN, WARN, cause, uninjectFailed$str(), serviceName, valueInjection);
    }
    private static final String uninjectFailed = "MSC000006: Uninjection \"%2$s\" of %1$s failed unexpectedly";
    protected String uninjectFailed$str() {
        return uninjectFailed;
    }
    @Override
    public final void internalServiceError(final Throwable cause, final org.jboss.msc.service.ServiceName serviceName) {
        log.logf(FQCN, WARN, cause, internalServiceError$str(), serviceName);
    }
    private static final String internalServiceError = "MSC000007: An internal service error has occurred while processing an operation on %s";
    protected String internalServiceError$str() {
        return internalServiceError;
    }
    @Override
    public final void uncaughtException(final Throwable cause, final Thread thread) {
        log.logf(FQCN, ERROR, cause, uncaughtException$str(), thread);
    }
    private static final String uncaughtException = "MSC000008: Worker thread %s threw an uncaught exception";
    protected String uncaughtException$str() {
        return uncaughtException;
    }
    @Override
    public final void profileOutputCloseFailed(final IOException cause) {
        log.logf(FQCN, WARN, null, profileOutputCloseFailed$str(), cause);
    }
    private static final String profileOutputCloseFailed = "MSC000009: An error occurred while trying to close the profile output file: %s";
    protected String profileOutputCloseFailed$str() {
        return profileOutputCloseFailed;
    }
    @Override
    public final void mbeanFailed(final Exception e) {
        log.logf(FQCN, ERROR, e, mbeanFailed$str());
    }
    private static final String mbeanFailed = "MSC000010: Failed to register MBean with MBeanServer";
    protected String mbeanFailed$str() {
        return mbeanFailed;
    }
    private static final String serviceNotStarted = "MSC000011: Service not started";
    protected String serviceNotStarted$str() {
        return serviceNotStarted;
    }
    @Override
    public final IllegalStateException serviceNotStarted() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), serviceNotStarted$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void injectFailed(final Throwable cause, final org.jboss.msc.service.ServiceName serviceName) {
        log.logf(FQCN, ERROR, cause, injectFailed$str(), serviceName);
    }
    private static final String injectFailed = "MSC000012: Injection failed for service %s";
    protected String injectFailed$str() {
        return injectFailed;
    }
}
