/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.value;

import java.lang.reflect.Method;
import org.jboss.msc.value.Value;

public final class LookupGetMethodValue
implements Value<Method> {
    private final Value<Class<?>> target;
    private final String propertyName;

    public LookupGetMethodValue(Value<Class<?>> target, String propertyName) {
        if (target == null) {
            throw new IllegalArgumentException("target is null");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName is null");
        }
        this.target = target;
        this.propertyName = propertyName;
    }

    @Override
    public Method getValue() throws IllegalStateException {
        Class<?> targetClass = this.target.getValue();
        String propertyName = this.propertyName;
        String getterName = "get" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        try {
            return targetClass.getMethod(getterName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            String iserName = "is" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
            try {
                return targetClass.getMethod(iserName, new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                throw new IllegalStateException("No such get method for property '" + propertyName + "' found on " + targetClass);
            }
        }
    }
}

