/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Location;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainerImpl;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceControllerImpl;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ValueInjection;
import org.jboss.msc.value.Value;

final class ServiceBuilderImpl<S>
implements ServiceBuilder<S> {
    private final ServiceContainerImpl container;
    private final List<ServiceControllerImpl<?>> deps = new ArrayList(0);
    private final List<ValueInjection<?>> injections = new ArrayList(0);
    private final List<ServiceListener<? super S>> listeners = new ArrayList<ServiceListener<? super S>>(0);
    private final List<ServiceName> aliases = new ArrayList<ServiceName>(0);
    private final Value<? extends Service<? extends S>> service;
    private final ServiceName serviceName;
    private ServiceController.Mode mode = ServiceController.Mode.AUTOMATIC;
    private ServiceControllerImpl<S> controller;
    private Location location;
    private static final ServiceControllerImpl<?>[] NO_DEPS = new ServiceControllerImpl[0];
    private static final ValueInjection<?>[] NO_INJECTIONS = new ValueInjection[0];
    private static final ServiceName[] NO_ALIASES = new ServiceName[0];

    ServiceBuilderImpl(ServiceContainerImpl container, Value<? extends Service<? extends S>> service, ServiceName serviceName) {
        this.container = container;
        this.service = service;
        this.serviceName = serviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDependency(ServiceController<?> dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException("dependency is null");
        }
        ServiceBuilderImpl serviceBuilderImpl = this;
        synchronized (serviceBuilderImpl) {
            if (this.controller != null) {
                throw new IllegalStateException();
            }
            if (!(dependency instanceof ServiceControllerImpl)) {
                throw new IllegalArgumentException("Given dependency has an invalid implementation");
            }
            this.deps.add((ServiceControllerImpl)dependency);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> ServiceBuilderImpl<S> addValueInjection(ValueInjection<T> injection) {
        if (injection == null) {
            throw new IllegalArgumentException("injection is null");
        }
        ServiceBuilderImpl serviceBuilderImpl = this;
        synchronized (serviceBuilderImpl) {
            if (this.controller != null) {
                throw new IllegalStateException();
            }
            this.injections.add(injection);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> ServiceBuilderImpl<S> addValueInjection(ServiceController<T> dependency, Injector<T> injector) {
        if (dependency == null) {
            throw new IllegalArgumentException("dependency is null");
        }
        if (injector == null) {
            throw new IllegalArgumentException("injector is null");
        }
        ServiceBuilderImpl serviceBuilderImpl = this;
        synchronized (serviceBuilderImpl) {
            if (this.controller != null) {
                throw new IllegalStateException();
            }
            if (!(dependency instanceof ServiceControllerImpl)) {
                throw new IllegalArgumentException("Given dependency has an invalid implementation");
            }
            this.deps.add((ServiceControllerImpl)dependency);
            this.injections.add(new ValueInjection<T>(dependency, injector));
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceBuilderImpl<S> addListener(ServiceListener<? super S> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        ServiceBuilderImpl serviceBuilderImpl = this;
        synchronized (serviceBuilderImpl) {
            if (this.controller != null) {
                throw new IllegalStateException();
            }
            this.listeners.add(listener);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceBuilderImpl<S> setInitialMode(ServiceController.Mode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("mode is null");
        }
        ServiceBuilderImpl serviceBuilderImpl = this;
        synchronized (serviceBuilderImpl) {
            if (this.controller != null) {
                throw new IllegalStateException();
            }
            this.mode = mode;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceBuilderImpl<S> setLocation(Location location) {
        ServiceBuilderImpl serviceBuilderImpl = this;
        synchronized (serviceBuilderImpl) {
            if (this.controller != null) {
                throw new IllegalStateException();
            }
            this.location = location;
            return this;
        }
    }

    @Override
    public ServiceBuilderImpl<S> setLocation() {
        StackTraceElement element = new Throwable().getStackTrace()[1];
        String fileName = element.getFileName();
        int lineNumber = element.getLineNumber();
        return this.setLocation(new Location(fileName, lineNumber, -1, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceControllerImpl<S> create() {
        ServiceBuilderImpl serviceBuilderImpl = this;
        synchronized (serviceBuilderImpl) {
            ServiceControllerImpl<S> controller = this.controller;
            return controller != null ? controller : this.doCreate();
        }
    }

    @Override
    public ServiceBuilderImpl<S> addAlias(ServiceName alias) {
        this.aliases.add(alias);
        return this;
    }

    @Override
    public ServiceBuilderImpl<S> addAliases(ServiceName ... aliases) {
        this.aliases.addAll(Arrays.asList(aliases));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceControllerImpl<S> doCreate() {
        ServiceBuilderImpl serviceBuilderImpl = this;
        synchronized (serviceBuilderImpl) {
            List<ServiceControllerImpl<?>> deps = this.deps;
            List<ValueInjection<?>> injections = this.injections;
            int depsSize = deps.size();
            int injectionsSize = injections.size();
            int aliasesSize = this.aliases.size();
            ServiceControllerImpl<?>[] depArray = depsSize == 0 ? NO_DEPS : deps.toArray(new ServiceControllerImpl[depsSize]);
            ValueInjection<?>[] injectionArray = injectionsSize == 0 ? NO_INJECTIONS : injections.toArray(new ValueInjection[injectionsSize]);
            ServiceName[] aliasNames = aliasesSize == 0 ? NO_ALIASES : this.aliases.toArray(new ServiceName[aliasesSize]);
            this.controller = new ServiceControllerImpl<S>(this.container, this.service, this.location, depArray, injectionArray, this.serviceName, aliasNames);
            ServiceControllerImpl<? super S> controller = this.controller;
            controller.initialize();
            for (ServiceListener<? super S> serviceListener : this.listeners) {
                controller.addListener(serviceListener);
            }
            controller.setMode(this.mode);
            return controller;
        }
    }
}

