/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.jboss.msc.Version;
import org.jboss.msc.service.IdentityHashSet;
import org.jboss.msc.service.Location;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceContainerImpl;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceLogger;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.service.ValueInjection;
import org.jboss.msc.value.Value;

final class ServiceControllerImpl<S>
implements ServiceController<S> {
    private static final String ILLEGAL_CONTROLLER_STATE = "Illegal controller state";
    private static final String SERVICE_REMOVED = "Service has been removed";
    private static final ServiceControllerImpl<?>[] NO_DEPENDENTS = new ServiceControllerImpl[0];
    private final ServiceContainerImpl container;
    private final Value<? extends Service<? extends S>> serviceValue;
    private final Location location;
    private final ServiceControllerImpl<?>[] dependencies;
    private final ValueInjection<?>[] injections;
    private final IdentityHashSet<ServiceListener<? super S>> listeners = new IdentityHashSet(0);
    private final IdentityHashSet<ServiceControllerImpl<?>> dependents = new IdentityHashSet(0);
    private final ServiceName serviceName;
    private final ServiceName[] serviceAliases;
    private StartException startException;
    private ServiceController.Mode mode = ServiceController.Mode.NEVER;
    private Substate state = Substate.DOWN;
    private int demandedByCount;
    private int upperCount;
    private int runningDependents;
    private int asyncTasks;

    ServiceControllerImpl(ServiceContainerImpl container, Value<? extends Service<? extends S>> serviceValue, Location location, ServiceControllerImpl<?>[] dependencies, ValueInjection<?>[] injections, ServiceName serviceName, ServiceName[] serviceAliases) {
        this.container = container;
        this.serviceValue = serviceValue;
        this.location = location;
        this.dependencies = dependencies;
        this.injections = injections;
        this.serviceName = serviceName;
        this.serviceAliases = serviceAliases;
        this.upperCount = -dependencies.length;
    }

    void initialize() {
        for (ServiceControllerImpl<?> controller : this.dependencies) {
            super.addDependent(this);
        }
    }

    @Override
    public ServiceContainer getServiceContainer() {
        return this.container;
    }

    @Override
    public ServiceController.State getState() {
        return this.state.getState();
    }

    @Override
    public S getValue() throws IllegalStateException {
        return (S)this.serviceValue.getValue().getValue();
    }

    @Override
    public ServiceName getName() {
        return this.serviceName;
    }

    @Override
    public ServiceName[] getAliases() {
        ServiceName[] names = this.serviceAliases;
        return names.length == 0 ? names : (ServiceName[])names.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(ServiceListener<? super S> listener) {
        assert (!this.lockHeld());
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            Substate state = this.state;
            if (state != Substate.REMOVED && !this.listeners.add(listener)) {
                throw new IllegalArgumentException("Listener " + listener + " already present on controller for " + this.serviceName);
            }
            ++this.asyncTasks;
        }
        this.invokeListener(listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(ServiceListener<? super S> listener) {
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartException getStartException() {
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            return this.startException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retry() {
        Runnable[] tasks;
        assert (!this.lockHeld());
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            if (this.state.getState() != ServiceController.State.START_FAILED) {
                return;
            }
            this.startException = null;
            tasks = this.transition();
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceController.Mode getMode() {
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            return this.mode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMode(ServiceController.Mode newMode) {
        Runnable[] tasks;
        assert (!this.lockHeld());
        Runnable specialTask = null;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            block39: {
                ServiceController.Mode oldMode = this.mode;
                this.mode = newMode;
                block2 : switch (oldMode) {
                    case REMOVE: {
                        switch (newMode) {
                            case REMOVE: {
                                return;
                            }
                        }
                        throw new IllegalStateException(SERVICE_REMOVED);
                    }
                    case NEVER: {
                        switch (newMode) {
                            case NEVER: {
                                return;
                            }
                            case ON_DEMAND: {
                                if (this.demandedByCount <= 0) break;
                                ++this.upperCount;
                                break;
                            }
                            case AUTOMATIC: {
                                ++this.upperCount;
                                break;
                            }
                            case IMMEDIATE: {
                                specialTask = new DemandParentsTask();
                                ++this.asyncTasks;
                                ++this.upperCount;
                            }
                        }
                        break;
                    }
                    case ON_DEMAND: {
                        switch (newMode) {
                            case REMOVE: 
                            case NEVER: {
                                if (this.demandedByCount <= 0) break;
                                --this.upperCount;
                                break;
                            }
                            case ON_DEMAND: {
                                return;
                            }
                            case AUTOMATIC: {
                                if (this.demandedByCount != 0) break;
                                ++this.upperCount;
                                break;
                            }
                            case IMMEDIATE: {
                                specialTask = new DemandParentsTask();
                                ++this.asyncTasks;
                                if (this.demandedByCount != 0) break;
                                ++this.upperCount;
                            }
                        }
                        break;
                    }
                    case AUTOMATIC: {
                        switch (newMode) {
                            case REMOVE: 
                            case NEVER: {
                                --this.upperCount;
                                break;
                            }
                            case ON_DEMAND: {
                                if (this.demandedByCount != 0) break;
                                --this.upperCount;
                                break;
                            }
                            case AUTOMATIC: {
                                return;
                            }
                            case IMMEDIATE: {
                                specialTask = new DemandParentsTask();
                                ++this.asyncTasks;
                            }
                        }
                        break;
                    }
                    case IMMEDIATE: {
                        switch (newMode) {
                            case REMOVE: 
                            case NEVER: {
                                specialTask = new UndemandParentsTask();
                                ++this.asyncTasks;
                                --this.upperCount;
                                break block2;
                            }
                            case ON_DEMAND: {
                                specialTask = new UndemandParentsTask();
                                ++this.asyncTasks;
                                if (this.demandedByCount == 0) {
                                    --this.upperCount;
                                    break block2;
                                }
                                break block39;
                            }
                            case AUTOMATIC: {
                                specialTask = new UndemandParentsTask();
                                ++this.asyncTasks;
                                break block2;
                            }
                            case IMMEDIATE: {
                                return;
                            }
                        }
                    }
                }
            }
            tasks = this.transition();
        }
        this.doExecute(tasks);
        this.doExecute(specialTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDependent(ServiceControllerImpl<?> dependent) {
        Runnable[] tasks;
        Substate state;
        assert (!this.lockHeld());
        assert (!super.lockHeld());
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            state = this.state;
            if (state != Substate.REMOVED) {
                boolean result = this.dependents.add(dependent);
                assert (result);
            }
            if (state != Substate.UP) {
                return;
            }
            ++this.asyncTasks;
        }
        if (state == Substate.UP) {
            dependent.dependencyUp();
        }
        ServiceControllerImpl serviceControllerImpl2 = this;
        synchronized (serviceControllerImpl2) {
            --this.asyncTasks;
            tasks = this.transition();
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDependent(ServiceControllerImpl<?> dependent) {
        assert (!this.lockHeld());
        assert (!super.lockHeld());
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            this.dependents.remove(dependent);
        }
    }

    private Transition getTransition() {
        assert (this.lockHeld());
        if (this.asyncTasks != 0) {
            return null;
        }
        switch (this.state) {
            case DOWN: {
                if (this.mode == ServiceController.Mode.REMOVE) {
                    return Transition.DOWN_to_REMOVED;
                }
                if (this.mode == ServiceController.Mode.NEVER || this.upperCount <= 0) break;
                return Transition.DOWN_to_START_REQUESTED;
            }
            case STOPPING: {
                return Transition.STOPPING_to_DOWN;
            }
            case STOP_REQUESTED: {
                if (this.upperCount > 0) {
                    return Transition.STOP_REQUESTED_to_UP;
                }
                if (this.runningDependents != 0) break;
                return Transition.STOP_REQUESTED_to_STOPPING;
            }
            case UP: {
                if (this.upperCount > 0) break;
                return Transition.UP_to_STOP_REQUESTED;
            }
            case START_FAILED: {
                if (this.upperCount > 0) {
                    if (this.startException != null) break;
                    return Transition.START_FAILED_to_STARTING;
                }
                return Transition.START_FAILED_to_DOWN;
            }
            case STARTING: {
                if (this.startException == null) {
                    return Transition.STARTING_to_UP;
                }
                return Transition.STARTING_to_START_FAILED;
            }
            case START_REQUESTED: {
                if (this.upperCount > 0) {
                    return Transition.START_REQUESTED_to_STARTING;
                }
                return Transition.START_REQUESTED_to_DOWN;
            }
        }
        return null;
    }

    private Runnable[] transition() {
        Runnable[] tasks;
        assert (this.lockHeld());
        Transition transition = this.getTransition();
        if (transition == null) {
            return null;
        }
        switch (transition) {
            case STOPPING_to_DOWN: {
                tasks = this.getListenerTasks(transition.getAfter().getState(), new DependentStoppedTask());
                break;
            }
            case START_REQUESTED_to_DOWN: {
                tasks = new Runnable[]{new DependentStoppedTask()};
                break;
            }
            case START_REQUESTED_to_STARTING: {
                tasks = this.getListenerTasks(transition.getAfter().getState(), new StartTask(true));
                break;
            }
            case UP_to_STOP_REQUESTED: {
                tasks = new Runnable[]{new DependencyStoppedTask(this.dependents.toScatteredArray(NO_DEPENDENTS))};
                break;
            }
            case STARTING_to_UP: {
                tasks = this.getListenerTasks(transition.getAfter().getState(), new DependencyStartedTask(this.dependents.toScatteredArray(NO_DEPENDENTS)));
                break;
            }
            case STARTING_to_START_FAILED: {
                tasks = this.getListenerTasks(transition.getAfter().getState());
                break;
            }
            case START_FAILED_to_STARTING: {
                tasks = this.getListenerTasks(transition.getAfter().getState(), new StartTask(false));
                break;
            }
            case START_FAILED_to_DOWN: {
                this.startException = null;
                tasks = this.getListenerTasks(transition.getAfter().getState(), new StopTask(true), new DependentStoppedTask());
                break;
            }
            case STOP_REQUESTED_to_UP: {
                tasks = new Runnable[]{new DependencyStartedTask(this.dependents.toScatteredArray(NO_DEPENDENTS))};
                break;
            }
            case STOP_REQUESTED_to_STOPPING: {
                tasks = this.getListenerTasks(transition.getAfter().getState(), new StopTask(false));
                break;
            }
            case DOWN_to_REMOVED: {
                tasks = this.getListenerTasks(transition.getAfter().getState(), new RemoveTask(this.dependents.toScatteredArray(NO_DEPENDENTS)));
                this.listeners.clear();
                break;
            }
            case DOWN_to_START_REQUESTED: {
                tasks = new Runnable[]{new DependentStartedTask()};
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.state = transition.getAfter();
        this.asyncTasks += tasks.length;
        return tasks;
    }

    private Runnable[] getListenerTasks(ServiceController.State newState, Runnable extraTask1, Runnable extraTask2) {
        IdentityHashSet<ServiceListener<S>> listeners = this.listeners;
        int size = listeners.size();
        Runnable[] tasks = new Runnable[size + 2];
        int i = 0;
        for (ServiceListener<? super S> serviceListener : listeners) {
            tasks[i++] = new ListenerTask(serviceListener, newState);
        }
        tasks[i++] = extraTask1;
        tasks[i] = extraTask2;
        return tasks;
    }

    private Runnable[] getListenerTasks(ServiceController.State newState, Runnable extraTask) {
        IdentityHashSet<ServiceListener<S>> listeners = this.listeners;
        int size = listeners.size();
        Runnable[] tasks = new Runnable[size + 1];
        int i = 0;
        for (ServiceListener<? super S> serviceListener : listeners) {
            tasks[i++] = new ListenerTask(serviceListener, newState);
        }
        tasks[i] = extraTask;
        return tasks;
    }

    private Runnable[] getListenerTasks(ServiceController.State newState) {
        IdentityHashSet<ServiceListener<S>> listeners = this.listeners;
        int size = listeners.size();
        Runnable[] tasks = new Runnable[size];
        int i = 0;
        for (ServiceListener<? super S> serviceListener : listeners) {
            tasks[i++] = new ListenerTask(serviceListener, newState);
        }
        return tasks;
    }

    private boolean lockHeld() {
        return Thread.holdsLock(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void invokeListener(ServiceListener<? super S> listener, ServiceController.State state) {
        assert (!this.lockHeld());
        try {
            if (state == null) {
                listener.listenerAdded(this);
                return;
            }
            switch (state) {
                case DOWN: {
                    listener.serviceStopped(this);
                    return;
                }
                case STARTING: {
                    listener.serviceStarting(this);
                    return;
                }
                case START_FAILED: {
                    listener.serviceFailed(this, this.startException);
                    return;
                }
                case UP: {
                    listener.serviceStarted(this);
                    return;
                }
                case STOPPING: {
                    listener.serviceStopping(this);
                    return;
                }
                case REMOVED: {
                    listener.serviceRemoved(this);
                    return;
                }
            }
            return;
        }
        catch (Throwable t) {
            ServiceLogger.INSTANCE.listenerFailed(t, listener);
            return;
        }
        finally {
            Runnable[] tasks;
            ServiceControllerImpl serviceControllerImpl = this;
            synchronized (serviceControllerImpl) {
                --this.asyncTasks;
                tasks = this.transition();
            }
            this.doExecute(tasks);
        }
    }

    private void doExecute(Runnable task) {
        assert (!this.lockHeld());
        if (task == null) {
            return;
        }
        try {
            this.container.getExecutor().execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
    }

    private void doExecute(Runnable ... tasks) {
        assert (!this.lockHeld());
        if (tasks == null) {
            return;
        }
        Executor executor = this.container.getExecutor();
        for (Runnable task : tasks) {
            try {
                executor.execute(task);
            }
            catch (RejectedExecutionException e) {
                task.run();
            }
        }
    }

    private static <T> void doInject(ValueInjection<T> injection) {
        injection.getTarget().inject(injection.getSource().getValue());
    }

    private void doDemandParents() {
        assert (!this.lockHeld());
        for (ServiceControllerImpl<?> dependency : this.dependencies) {
            dependency.addDemand();
        }
    }

    private void doUndemandParents() {
        assert (!this.lockHeld());
        for (ServiceControllerImpl<?> dependency : this.dependencies) {
            dependency.removeDemand();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDemand() {
        Runnable[] tasks;
        assert (!this.lockHeld());
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            int cnt = this.demandedByCount++;
            if (cnt != 0 || this.mode != ServiceController.Mode.ON_DEMAND) {
                return;
            }
            ++this.upperCount;
            tasks = this.transition();
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDemand() {
        Runnable[] tasks;
        assert (!this.lockHeld());
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            int cnt = --this.demandedByCount;
            if (cnt != 0 || this.mode != ServiceController.Mode.ON_DEMAND) {
                return;
            }
            --this.upperCount;
            tasks = this.transition();
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dependentStarted() {
        assert (!this.lockHeld());
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            ++this.runningDependents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dependentStopped() {
        Runnable[] tasks;
        assert (!this.lockHeld());
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            if (--this.runningDependents != 0) {
                return;
            }
            tasks = this.transition();
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dependencyUp() {
        Runnable[] tasks = null;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            if (++this.upperCount != 1) {
                return;
            }
            tasks = this.transition();
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dependencyDown() {
        Runnable[] tasks = null;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            if (--this.upperCount != 0) {
                return;
            }
            tasks = this.transition();
        }
        this.doExecute(tasks);
    }

    static {
        ServiceLogger.INSTANCE.greeting(Version.getVersionString());
    }

    private class UndemandParentsTask
    implements Runnable {
        private UndemandParentsTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Runnable[] tasks;
                ServiceControllerImpl.this.doUndemandParents();
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    ServiceControllerImpl.this.asyncTasks--;
                    tasks = ServiceControllerImpl.this.transition();
                }
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (Throwable t) {
                ServiceLogger.INSTANCE.internalServiceError(t, ServiceControllerImpl.this.serviceName);
            }
        }
    }

    private class DemandParentsTask
    implements Runnable {
        private DemandParentsTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Runnable[] tasks;
                ServiceControllerImpl.this.doDemandParents();
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    ServiceControllerImpl.this.asyncTasks--;
                    tasks = ServiceControllerImpl.this.transition();
                }
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (Throwable t) {
                ServiceLogger.INSTANCE.internalServiceError(t, ServiceControllerImpl.this.serviceName);
            }
        }
    }

    private class RemoveTask
    implements Runnable {
        private final ServiceControllerImpl<?>[] dependents;

        RemoveTask(ServiceControllerImpl<?>[] dependents) {
            this.dependents = dependents;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                assert (ServiceControllerImpl.this.getMode() == ServiceController.Mode.REMOVE);
                assert (ServiceControllerImpl.this.getState() == ServiceController.State.REMOVED);
                ServiceControllerImpl.this.container.remove(ServiceControllerImpl.this.serviceName, ServiceControllerImpl.this);
                for (ServiceName name : ServiceControllerImpl.this.serviceAliases) {
                    ServiceControllerImpl.this.container.remove(name, ServiceControllerImpl.this);
                }
                for (ServiceControllerImpl<?> dependent : this.dependents) {
                    if (dependent == null) continue;
                    dependent.setMode(ServiceController.Mode.REMOVE);
                }
                for (ServiceControllerImpl dependency : ServiceControllerImpl.this.dependencies) {
                    dependency.removeDependent(ServiceControllerImpl.this);
                }
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    Arrays.fill(ServiceControllerImpl.this.dependencies, null);
                    ServiceControllerImpl.this.asyncTasks--;
                }
            }
            catch (Throwable throwable) {
                ServiceLogger.INSTANCE.internalServiceError(throwable, ServiceControllerImpl.this.serviceName);
            }
        }
    }

    private class DependencyStoppedTask
    implements Runnable {
        private final ServiceControllerImpl<?>[] dependents;

        DependencyStoppedTask(ServiceControllerImpl<?>[] dependents) {
            this.dependents = dependents;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Runnable[] tasks;
                for (ServiceControllerImpl<?> dependent : this.dependents) {
                    if (dependent == null) continue;
                    dependent.dependencyDown();
                }
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    ServiceControllerImpl.this.asyncTasks--;
                    tasks = ServiceControllerImpl.this.transition();
                }
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (Throwable t) {
                ServiceLogger.INSTANCE.internalServiceError(t, ServiceControllerImpl.this.serviceName);
            }
        }
    }

    private class DependencyStartedTask
    implements Runnable {
        private final ServiceControllerImpl<?>[] dependents;

        DependencyStartedTask(ServiceControllerImpl<?>[] dependents) {
            this.dependents = dependents;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Runnable[] tasks;
                for (ServiceControllerImpl<?> dependent : this.dependents) {
                    if (dependent == null) continue;
                    dependent.dependencyUp();
                }
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    ServiceControllerImpl.this.asyncTasks--;
                    tasks = ServiceControllerImpl.this.transition();
                }
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (Throwable t) {
                ServiceLogger.INSTANCE.internalServiceError(t, ServiceControllerImpl.this.serviceName);
            }
        }
    }

    private class DependentStartedTask
    implements Runnable {
        private DependentStartedTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Runnable[] tasks;
                for (ServiceControllerImpl controller : ServiceControllerImpl.this.dependencies) {
                    controller.dependentStarted();
                }
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    ServiceControllerImpl.this.asyncTasks--;
                    tasks = ServiceControllerImpl.this.transition();
                }
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (Throwable t) {
                ServiceLogger.INSTANCE.internalServiceError(t, ServiceControllerImpl.this.serviceName);
            }
        }
    }

    private class DependentStoppedTask
    implements Runnable {
        private DependentStoppedTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Runnable[] tasks;
                for (ServiceControllerImpl controller : ServiceControllerImpl.this.dependencies) {
                    controller.dependentStopped();
                }
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    ServiceControllerImpl.this.asyncTasks--;
                    tasks = ServiceControllerImpl.this.transition();
                }
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (Throwable t) {
                ServiceLogger.INSTANCE.internalServiceError(t, ServiceControllerImpl.this.serviceName);
            }
        }
    }

    private class ListenerTask
    implements Runnable {
        private final ServiceListener<? super S> listener;
        private final ServiceController.State state;

        ListenerTask(ServiceListener<? super S> listener, ServiceController.State state) {
            this.listener = listener;
            this.state = state;
        }

        @Override
        public void run() {
            assert (!ServiceControllerImpl.this.lockHeld());
            ServiceControllerImpl.this.invokeListener(this.listener, this.state);
        }
    }

    private class StopTask
    implements Runnable {
        private final boolean onlyUninject;

        StopTask(boolean onlyUninject) {
            this.onlyUninject = onlyUninject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block25: {
                assert (!ServiceControllerImpl.this.lockHeld());
                StopContextImpl context = new StopContextImpl();
                boolean ok = false;
                try {
                    if (this.onlyUninject) break block25;
                    try {
                        Service service = (Service)ServiceControllerImpl.this.serviceValue.getValue();
                        if (service != null) {
                            service.stop(context);
                            ok = true;
                            break block25;
                        }
                        ServiceLogger.INSTANCE.stopServiceMissing(ServiceControllerImpl.this.serviceName);
                    }
                    catch (Throwable t) {
                        ServiceLogger.INSTANCE.stopFailed(t, ServiceControllerImpl.this.serviceName);
                    }
                }
                finally {
                    Runnable[] tasks = null;
                    ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                    synchronized (serviceControllerImpl) {
                        if (ok && context.state != ContextState.SYNC) {
                            return;
                        }
                        context.state = ContextState.COMPLETE;
                    }
                    for (ValueInjection injection : ServiceControllerImpl.this.injections) {
                        try {
                            injection.getTarget().uninject();
                        }
                        catch (Throwable t) {
                            ServiceLogger.INSTANCE.uninjectFailed(t, ServiceControllerImpl.this.serviceName, injection);
                        }
                    }
                    serviceControllerImpl = ServiceControllerImpl.this;
                    synchronized (serviceControllerImpl) {
                        ServiceControllerImpl.this.asyncTasks--;
                        tasks = ServiceControllerImpl.this.transition();
                    }
                    ServiceControllerImpl.this.doExecute(tasks);
                }
            }
        }
    }

    private class StartTask
    implements Runnable {
        private final boolean doInjection;

        StartTask(boolean doInjection) {
            this.doInjection = doInjection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            assert (!ServiceControllerImpl.this.lockHeld());
            StartContextImpl context = new StartContextImpl();
            try {
                Runnable[] tasks;
                Service service;
                if (this.doInjection) {
                    int i;
                    ValueInjection[] injections = ServiceControllerImpl.this.injections;
                    int injectionsLength = injections.length;
                    boolean ok = false;
                    try {
                        for (i = 0; i < injectionsLength; ++i) {
                            ValueInjection injection = injections[i];
                            ServiceControllerImpl.doInject(injection);
                        }
                        ok = true;
                    }
                    finally {
                        if (!ok) {
                            while (i >= 0) {
                                injections[i].getTarget().uninject();
                                --i;
                            }
                        }
                    }
                }
                if ((service = (Service)ServiceControllerImpl.this.serviceValue.getValue()) == null) {
                    throw new IllegalArgumentException("Service is null");
                }
                service.start(context);
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    if (context.state != ContextState.SYNC) {
                        return;
                    }
                    context.state = ContextState.COMPLETE;
                    ServiceControllerImpl.this.asyncTasks--;
                    tasks = ServiceControllerImpl.this.transition();
                }
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (StartException e) {
                Runnable[] tasks;
                e.setServiceName(ServiceControllerImpl.this.serviceName);
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    ContextState oldState = context.state;
                    if (oldState != ContextState.SYNC && oldState != ContextState.ASYNC) {
                        ServiceLogger.INSTANCE.exceptionAfterComplete(e, ServiceControllerImpl.this.serviceName);
                        return;
                    }
                    context.state = ContextState.FAILED;
                    ServiceControllerImpl.this.asyncTasks--;
                    ServiceControllerImpl.this.startException = e;
                    tasks = ServiceControllerImpl.this.transition();
                }
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (Throwable t) {
                Runnable[] tasks;
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    ContextState oldState = context.state;
                    if (oldState != ContextState.SYNC && oldState != ContextState.ASYNC) {
                        ServiceLogger.INSTANCE.exceptionAfterComplete(t, ServiceControllerImpl.this.serviceName);
                        return;
                    }
                    context.state = ContextState.FAILED;
                    ServiceControllerImpl.this.asyncTasks--;
                    ServiceControllerImpl.this.startException = new StartException("Failed to start service", t, ServiceControllerImpl.this.location, ServiceControllerImpl.this.serviceName);
                    tasks = ServiceControllerImpl.this.transition();
                }
                ServiceControllerImpl.this.doExecute(tasks);
            }
        }
    }

    static enum Transition {
        START_REQUESTED_to_DOWN(Substate.START_REQUESTED, Substate.DOWN),
        START_REQUESTED_to_STARTING(Substate.START_REQUESTED, Substate.STARTING),
        STARTING_to_UP(Substate.STARTING, Substate.UP),
        STARTING_to_START_FAILED(Substate.STARTING, Substate.START_FAILED),
        START_FAILED_to_STARTING(Substate.START_FAILED, Substate.STARTING),
        START_FAILED_to_DOWN(Substate.START_FAILED, Substate.DOWN),
        UP_to_STOP_REQUESTED(Substate.UP, Substate.STOP_REQUESTED),
        STOP_REQUESTED_to_UP(Substate.STOP_REQUESTED, Substate.UP),
        STOP_REQUESTED_to_STOPPING(Substate.STOP_REQUESTED, Substate.STOPPING),
        STOPPING_to_DOWN(Substate.STOPPING, Substate.DOWN),
        DOWN_to_REMOVED(Substate.DOWN, Substate.REMOVED),
        DOWN_to_START_REQUESTED(Substate.DOWN, Substate.START_REQUESTED);

        private final Substate before;
        private final Substate after;

        private Transition(Substate before, Substate after) {
            this.before = before;
            this.after = after;
        }

        public Substate getBefore() {
            return this.before;
        }

        public Substate getAfter() {
            return this.after;
        }
    }

    static enum Substate {
        DOWN(ServiceController.State.DOWN),
        START_REQUESTED(ServiceController.State.DOWN),
        STARTING(ServiceController.State.STARTING),
        START_FAILED(ServiceController.State.START_FAILED),
        UP(ServiceController.State.UP),
        STOP_REQUESTED(ServiceController.State.UP),
        STOPPING(ServiceController.State.STOPPING),
        REMOVED(ServiceController.State.REMOVED);

        private final ServiceController.State state;

        private Substate(ServiceController.State state) {
            this.state = state;
        }

        public ServiceController.State getState() {
            return this.state;
        }
    }

    private class StopContextImpl
    implements StopContext {
        private ContextState state = ContextState.SYNC;

        private StopContextImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void asynchronous() throws IllegalStateException {
            ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl) {
                if (this.state != ContextState.SYNC) {
                    throw new IllegalStateException(ServiceControllerImpl.ILLEGAL_CONTROLLER_STATE);
                }
                this.state = ContextState.ASYNC;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void complete() throws IllegalStateException {
            Runnable[] tasks;
            ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl) {
                if (this.state != ContextState.ASYNC) {
                    throw new IllegalStateException(ServiceControllerImpl.ILLEGAL_CONTROLLER_STATE);
                }
                this.state = ContextState.COMPLETE;
            }
            for (ValueInjection injection : ServiceControllerImpl.this.injections) {
                injection.getTarget().uninject();
            }
            ServiceControllerImpl serviceControllerImpl2 = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl2) {
                ServiceControllerImpl.this.asyncTasks--;
                tasks = ServiceControllerImpl.this.transition();
            }
            ServiceControllerImpl.this.doExecute(tasks);
        }

        @Override
        public ServiceController<?> getController() {
            return ServiceControllerImpl.this;
        }
    }

    private class StartContextImpl
    implements StartContext {
        private ContextState state = ContextState.SYNC;

        private StartContextImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failed(StartException reason) throws IllegalStateException {
            Runnable[] tasks;
            ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl) {
                if (this.state != ContextState.ASYNC) {
                    throw new IllegalStateException(ServiceControllerImpl.ILLEGAL_CONTROLLER_STATE);
                }
                this.state = ContextState.FAILED;
                ServiceControllerImpl.this.startException = reason;
                ServiceControllerImpl.this.asyncTasks--;
                tasks = ServiceControllerImpl.this.transition();
            }
            ServiceControllerImpl.this.doExecute(tasks);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void asynchronous() throws IllegalStateException {
            ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl) {
                if (this.state != ContextState.SYNC) {
                    throw new IllegalStateException(ServiceControllerImpl.ILLEGAL_CONTROLLER_STATE);
                }
                this.state = ContextState.ASYNC;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void complete() throws IllegalStateException {
            Runnable[] tasks;
            ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl) {
                if (this.state != ContextState.ASYNC) {
                    throw new IllegalStateException(ServiceControllerImpl.ILLEGAL_CONTROLLER_STATE);
                }
                this.state = ContextState.COMPLETE;
                ServiceControllerImpl.this.asyncTasks--;
                tasks = ServiceControllerImpl.this.transition();
            }
            ServiceControllerImpl.this.doExecute(tasks);
        }

        @Override
        public ServiceController<?> getController() {
            return ServiceControllerImpl.this;
        }
    }

    static enum ContextState {
        SYNC,
        ASYNC,
        COMPLETE,
        FAILED;

    }
}

