/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.msc.ref.Reaper;
import org.jboss.msc.ref.Reference;
import org.jboss.msc.ref.WeakReference;
import org.jboss.msc.service.BatchBuilderImpl;
import org.jboss.msc.service.BatchServiceBuilderImpl;
import org.jboss.msc.service.CircularDependencyException;
import org.jboss.msc.service.DuplicateServiceException;
import org.jboss.msc.service.MissingDependencyException;
import org.jboss.msc.service.NamedInjection;
import org.jboss.msc.service.ResolutionException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceBuilderImpl;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceControllerImpl;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceNotFoundException;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.service.ValueInjection;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.jboss.msc.value.Values;

final class ServiceContainerImpl
implements ServiceContainer {
    final Object lock = new Object();
    final ServiceControllerImpl<ServiceContainer> root;
    static final ServiceName ROOT = ServiceName.of("ROOT");
    private volatile Executor executor;
    private final ConcurrentMap<ServiceName, ServiceController<?>> registry = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceContainerImpl() {
        Set set;
        Set set2 = set = ShutdownHookHolder.containers;
        synchronized (set2) {
            boolean down = ShutdownHookHolder.down;
            ServiceBuilderImpl builder = new ServiceBuilderImpl(this, new ImmediateValue<1>(new Service<ServiceContainer>(){

                @Override
                public void start(StartContext context) throws StartException {
                }

                @Override
                public void stop(StopContext context) {
                }

                @Override
                public ServiceContainer getValue() throws IllegalStateException {
                    return ServiceContainerImpl.this;
                }
            }), ROOT);
            this.root = ((ServiceBuilderImpl)builder.setInitialMode(down ? ServiceController.Mode.REMOVE : ServiceController.Mode.AUTOMATIC)).create();
            if (!down) {
                set.add(new WeakReference<ServiceContainerImpl, Void>(this, null, new Reaper<ServiceContainerImpl, Void>(){

                    @Override
                    public void reap(Reference<ServiceContainerImpl, Void> reference) {
                        ShutdownHookHolder.containers.remove(reference);
                    }
                }));
            }
        }
    }

    public <T> ServiceBuilderImpl<T> buildService(Value<? extends Service<? extends T>> service) {
        return this.buildService(null, service);
    }

    public <T> ServiceBuilderImpl<T> buildService(ServiceName serviceName, Value<? extends Service<? extends T>> service) {
        ServiceBuilderImpl builder = new ServiceBuilderImpl(this, service, serviceName);
        builder.addDependency(this.root);
        return builder;
    }

    @Override
    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    @Override
    public void shutdown() {
        this.root.setMode(ServiceController.Mode.REMOVE);
    }

    protected void finalize() throws Throwable {
        this.root.setMode(ServiceController.Mode.REMOVE);
    }

    Executor getExecutor() {
        Executor executor = this.executor;
        return executor != null ? executor : ExecutorHolder.VALUE;
    }

    @Override
    public BatchBuilderImpl batchBuilder() {
        return new BatchBuilderImpl(this);
    }

    void install(BatchBuilderImpl serviceBatch) throws ServiceRegistryException {
        try {
            this.resolve(serviceBatch.getBatchServices());
        }
        catch (ResolutionException e) {
            throw new ServiceRegistryException("Failed to resolve dependencies", e);
        }
    }

    void remove(ServiceName serviceName, ServiceControllerImpl<?> controller) {
        this.registry.remove(serviceName, controller);
    }

    private void resolve(Map<ServiceName, BatchServiceBuilderImpl<?>> services) throws ServiceRegistryException {
        for (BatchServiceBuilderImpl<?> batchEntry : services.values()) {
            if (batchEntry.processed) continue;
            this.doResolve(batchEntry, services);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> void doResolve(BatchServiceBuilderImpl<T> entry222, Map<ServiceName, BatchServiceBuilderImpl<?>> services) throws ServiceRegistryException {
        block0: while (entry222 != null) {
            void entry222;
            Value serviceValue = entry222.getServiceValue();
            ServiceName name = entry222.getName();
            ServiceBuilder<Object> builder = entry222.builder;
            if (builder == null) {
                entry222.builder = this.buildService(name, serviceValue);
                builder = entry222.builder;
            }
            builder.addAliases(entry222.getAliases());
            ServiceName[] deps = entry222.getDependencies();
            ServiceName[] aliases = entry222.getAliases();
            while (entry222.i < deps.length) {
                ServiceName dependencyName = deps[entry222.i];
                ServiceController serviceController = (ServiceController)this.registry.get(dependencyName);
                if (serviceController == null) {
                    BatchServiceBuilderImpl dependencyEntry = (BatchServiceBuilderImpl)services.get(dependencyName);
                    if (dependencyEntry != null) {
                        assert (dependencyEntry.prev == null);
                        dependencyEntry.prev = entry222;
                        entry222.visited = true;
                        BatchServiceBuilderImpl entry222 = dependencyEntry;
                        if (!entry222.visited) continue block0;
                        throw new CircularDependencyException("Circular dependency discovered: " + name);
                    }
                    if (!entry222.isOptionalDependency(dependencyName)) throw new MissingDependencyException("Missing dependency: " + name + " depends on " + dependencyName + " which can not be found");
                    entry222.missingOptionalDependencies.add(dependencyName);
                } else {
                    builder.addDependency(serviceController);
                }
                ++entry222.i;
            }
            for (ServiceListener serviceListener : entry222.getListeners()) {
                builder.addListener(serviceListener);
            }
            for (NamedInjection namedInjection : entry222.getNamedInjections()) {
                if (!entry222.missingOptionalDependencies.contains(namedInjection.getName())) {
                    builder.addValueInjection(new ValueInjection<Object>(this.getRequiredService(namedInjection.getName()), namedInjection.getTarget()));
                    continue;
                }
                builder.addValueInjection(new ValueInjection<Object>(Values.nullValue(), namedInjection.getTarget()));
            }
            for (ValueInjection valueInjection : entry222.getValueInjections()) {
                builder.addValueInjection(valueInjection);
            }
            ServiceController.Mode initialMode = entry222.getInitialMode();
            builder.setInitialMode(ServiceController.Mode.NEVER);
            ServiceController serviceController = builder.create();
            if (this.registry.putIfAbsent(name, serviceController) != null) {
                if (!entry222.isIfNotExist()) {
                    throw new DuplicateServiceException("Duplicate service name provided: " + name);
                }
            } else {
                for (ServiceName alias : aliases) {
                    if (this.registry.putIfAbsent(alias, serviceController) == null) continue;
                    throw new DuplicateServiceException("Duplicate service name provided: " + alias);
                }
            }
            serviceController.setMode(initialMode == null ? ServiceController.Mode.AUTOMATIC : initialMode);
            entry222.builder = null;
            BatchServiceBuilderImpl<?> prev = entry222.prev;
            entry222.prev = null;
            entry222.processed = true;
            entry222.visited = false;
            BatchServiceBuilderImpl<?> entry222 = prev;
        }
    }

    @Override
    public ServiceController<?> getRequiredService(ServiceName serviceName) throws ServiceNotFoundException {
        ServiceController<?> controller = this.getService(serviceName);
        if (controller == null) {
            throw new ServiceNotFoundException("Service " + serviceName + " not found");
        }
        return controller;
    }

    @Override
    public ServiceController<?> getService(ServiceName serviceName) {
        return (ServiceController)this.registry.get(serviceName);
    }

    static final class LatchListener
    extends CountDownLatch
    implements ServiceListener<Object> {
        public LatchListener(int count) {
            super(count);
        }

        @Override
        public void listenerAdded(ServiceController<?> serviceController) {
            ServiceController.State state = serviceController.getState();
            if (state == ServiceController.State.REMOVED) {
                this.countDown();
            }
        }

        @Override
        public void serviceStarting(ServiceController<?> serviceController) {
        }

        @Override
        public void serviceStarted(ServiceController<?> serviceController) {
        }

        @Override
        public void serviceFailed(ServiceController<?> serviceController, StartException reason) {
        }

        @Override
        public void serviceStopping(ServiceController<?> serviceController) {
        }

        @Override
        public void serviceStopped(ServiceController<?> serviceController) {
        }

        @Override
        public void serviceRemoved(ServiceController<?> serviceController) {
            this.countDown();
        }
    }

    private static final class ShutdownHookHolder {
        private static final Set<Reference<ServiceContainerImpl, Void>> containers;
        private static boolean down;

        private ShutdownHookHolder() {
        }

        static {
            down = false;
            containers = new HashSet<Reference<ServiceContainerImpl, Void>>();
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Thread hook = new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            LatchListener listener;
                            Set set;
                            Set set2 = set = containers;
                            synchronized (set2) {
                                down = true;
                                listener = new LatchListener(set.size());
                                for (Reference containerRef : set) {
                                    ServiceContainerImpl container = (ServiceContainerImpl)containerRef.get();
                                    if (container == null) {
                                        listener.countDown();
                                        continue;
                                    }
                                    ServiceControllerImpl<ServiceContainer> root = container.root;
                                    root.setMode(ServiceController.Mode.REMOVE);
                                    root.addListener(listener);
                                }
                                set.clear();
                            }
                            while (true) {
                                try {
                                    listener.await();
                                }
                                catch (InterruptedException interruptedException) {
                                    continue;
                                }
                                break;
                            }
                        }
                    });
                    hook.setDaemon(true);
                    Runtime.getRuntime().addShutdownHook(hook);
                    return null;
                }
            });
        }
    }

    private static final class ExecutorHolder {
        private static final Executor VALUE;

        private ExecutorHolder() {
        }

        static {
            ThreadPoolExecutor executor = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r);
                    thread.setDaemon(true);
                    thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                        @Override
                        public void uncaughtException(Thread t, Throwable e) {
                            e.printStackTrace(System.err);
                        }
                    });
                    return thread;
                }
            });
            executor.allowCoreThreadTimeOut(true);
            executor.setCorePoolSize(1);
            VALUE = executor;
        }
    }
}

