/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.msc.inject.CastingInjector;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.BatchBuilderImpl;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Location;
import org.jboss.msc.service.NamedInjection;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ValueInjection;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

final class BatchServiceBuilderImpl<T>
implements BatchServiceBuilder<T> {
    private final BatchBuilderImpl batchBuilder;
    private final Value<? extends Service<T>> serviceValue;
    private final ServiceName serviceName;
    private final boolean ifNotExist;
    private Location location;
    private ServiceController.Mode initialMode;
    private final Set<ServiceName> aliases = new HashSet<ServiceName>(0);
    private final Map<ServiceName, Boolean> dependencies = new HashMap<ServiceName, Boolean>(0);
    private final List<ServiceListener<? super T>> listeners = new ArrayList<ServiceListener<? super T>>(0);
    private final List<ValueInjection<?>> valueInjections = new ArrayList(0);
    private final List<NamedInjection> namedInjections = new ArrayList<NamedInjection>(0);
    private ServiceName[] dependenciesArray;
    boolean processed;
    boolean visited;
    BatchServiceBuilderImpl<?> prev;
    int i;
    ServiceBuilder<T> builder;
    final Set<ServiceName> missingOptionalDependencies = new HashSet<ServiceName>();

    BatchServiceBuilderImpl(BatchBuilderImpl batchBuilder, Value<? extends Service<T>> serviceValue, ServiceName serviceName, boolean ifNotExist) {
        if (batchBuilder == null) {
            throw new IllegalArgumentException("BatchBuilder can not be null");
        }
        this.batchBuilder = batchBuilder;
        if (serviceValue == null) {
            throw new IllegalArgumentException("ServiceValue can not be null");
        }
        this.serviceValue = serviceValue;
        if (serviceName == null) {
            throw new IllegalArgumentException("ServiceName can not be null");
        }
        this.serviceName = serviceName;
        this.ifNotExist = ifNotExist;
    }

    @Override
    public BatchServiceBuilder<T> addAliases(ServiceName ... aliases) {
        for (ServiceName alias : aliases) {
            if (alias.equals(this.serviceName)) continue;
            this.aliases.add(alias);
        }
        return this;
    }

    @Override
    public BatchServiceBuilderImpl<T> setLocation() {
        this.checkAlreadyInstalled();
        StackTraceElement element = new Throwable().getStackTrace()[1];
        String fileName = element.getFileName();
        int lineNumber = element.getLineNumber();
        return this.setLocation(new Location(fileName, lineNumber, -1, null));
    }

    @Override
    public BatchServiceBuilderImpl<T> setLocation(Location location) {
        this.checkAlreadyInstalled();
        this.location = location;
        return this;
    }

    @Override
    public BatchServiceBuilderImpl<T> setInitialMode(ServiceController.Mode mode) {
        this.checkAlreadyInstalled();
        this.initialMode = mode;
        return this;
    }

    @Override
    public BatchServiceBuilder<T> addDependencies(ServiceName ... newDependencies) {
        return this.addDependencies(false, newDependencies);
    }

    @Override
    public BatchServiceBuilder<T> addOptionalDependencies(ServiceName ... newDependencies) {
        return this.addDependencies(true, newDependencies);
    }

    private BatchServiceBuilder<T> addDependencies(boolean optional, ServiceName ... newDependencies) {
        this.checkAlreadyInstalled();
        for (ServiceName dependency : newDependencies) {
            if (this.serviceName.equals(dependency)) continue;
            this.doAddDependency(dependency, optional);
        }
        return this;
    }

    @Override
    public BatchServiceBuilder<T> addDependencies(Iterable<ServiceName> newDependencies) {
        return this.addDependencies(newDependencies, false);
    }

    @Override
    public BatchServiceBuilder<T> addOptionalDependencies(Iterable<ServiceName> newDependencies) {
        return this.addDependencies(newDependencies, true);
    }

    private BatchServiceBuilder<T> addDependencies(Iterable<ServiceName> newDependencies, boolean optional) {
        this.checkAlreadyInstalled();
        for (ServiceName dependency : newDependencies) {
            if (this.serviceName.equals(dependency)) continue;
            this.doAddDependency(dependency, optional);
        }
        return this;
    }

    @Override
    public BatchServiceBuilder<T> addDependency(ServiceName dependency) {
        return this.addDependency(dependency, false);
    }

    @Override
    public BatchServiceBuilder<T> addOptionalDependency(ServiceName dependency) {
        return this.addDependency(dependency, false);
    }

    private BatchServiceBuilder<T> addDependency(ServiceName dependency, boolean optional) {
        this.checkAlreadyInstalled();
        if (!this.serviceName.equals(dependency)) {
            this.doAddDependency(dependency, optional);
        }
        return this;
    }

    @Override
    public BatchServiceBuilder<T> addDependency(ServiceName dependency, Injector<Object> target) {
        return this.addDependency(dependency, target, false);
    }

    @Override
    public BatchServiceBuilder<T> addOptionalDependency(ServiceName dependency, Injector<Object> target) {
        return this.addDependency(dependency, target, true);
    }

    private BatchServiceBuilder<T> addDependency(ServiceName dependency, Injector<Object> target, boolean optional) {
        this.checkAlreadyInstalled();
        if (!this.serviceName.equals(dependency)) {
            this.doAddDependency(dependency, optional);
        }
        this.namedInjections.add(new NamedInjection(dependency, target));
        return this;
    }

    @Override
    public <I> BatchServiceBuilder<T> addDependency(ServiceName dependency, Class<I> type, Injector<I> target) {
        return this.addDependency(dependency, type, target, false);
    }

    @Override
    public <I> BatchServiceBuilder<T> addOptionalDependency(ServiceName dependency, Class<I> type, Injector<I> target) {
        return this.addDependency(dependency, type, target, true);
    }

    private <I> BatchServiceBuilder<T> addDependency(ServiceName dependency, Class<I> type, Injector<I> target, boolean optional) {
        this.checkAlreadyInstalled();
        if (!this.serviceName.equals(dependency)) {
            this.doAddDependency(dependency, optional);
        }
        this.namedInjections.add(new NamedInjection(dependency, new CastingInjector<I>(target, type)));
        return this;
    }

    private void doAddDependency(ServiceName dependency, boolean optional) {
        Boolean existing = this.dependencies.get(dependency);
        this.dependencies.put(dependency, existing != null ? existing.booleanValue() && optional : optional);
    }

    @Override
    public <I> BatchServiceBuilder<T> addInjection(Injector<? super I> target, I value) {
        return this.addInjectionValue(target, new ImmediateValue<I>(value));
    }

    @Override
    public <I> BatchServiceBuilder<T> addInjectionValue(Injector<? super I> target, Value<I> value) {
        this.checkAlreadyInstalled();
        this.valueInjections.add(new ValueInjection<I>(value, target));
        return this;
    }

    @Override
    public BatchServiceBuilderImpl<T> addListener(ServiceListener<? super T> listener) {
        this.checkAlreadyInstalled();
        this.listeners.add(listener);
        return this;
    }

    @Override
    public BatchServiceBuilderImpl<T> addListener(ServiceListener<? super T> ... serviceListeners) {
        this.checkAlreadyInstalled();
        for (ServiceListener<? super T> listener : serviceListeners) {
            List<ServiceListener<T>> listeners = this.listeners;
            listeners.add(listener);
        }
        return this;
    }

    @Override
    public BatchServiceBuilderImpl<T> addListener(Collection<? extends ServiceListener<? super T>> serviceListeners) {
        this.checkAlreadyInstalled();
        this.listeners.addAll(serviceListeners);
        return this;
    }

    private void checkAlreadyInstalled() {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
    }

    Value<? extends Service<T>> getServiceValue() {
        return this.serviceValue;
    }

    ServiceName getName() {
        return this.serviceName;
    }

    ServiceName[] getAliases() {
        return this.aliases.toArray(new ServiceName[this.aliases.size()]);
    }

    ServiceName[] getDependencies() {
        if (this.dependenciesArray == null) {
            this.dependenciesArray = this.dependencies.keySet().toArray(new ServiceName[this.dependencies.size()]);
        }
        return this.dependenciesArray;
    }

    boolean isOptionalDependency(ServiceName serviceName) {
        Boolean optional = this.dependencies.get(serviceName);
        return optional != null ? optional : false;
    }

    Iterable<? extends ServiceListener<? super T>> getListeners() {
        return this.listeners;
    }

    List<NamedInjection> getNamedInjections() {
        return this.namedInjections;
    }

    List<ValueInjection<?>> getValueInjections() {
        return this.valueInjections;
    }

    ServiceController.Mode getInitialMode() {
        return this.initialMode;
    }

    Location getLocation() {
        return this.location;
    }

    boolean isIfNotExist() {
        return this.ifNotExist;
    }
}

