/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.value;

import java.lang.reflect.Method;
import org.jboss.msc.value.Value;

public final class LookupSetMethodValue
implements Value<Method> {
    private final Value<Class<?>> target;
    private final String propertyName;
    private final Value<Class<?>> propertyType;

    public LookupSetMethodValue(Value<Class<?>> target, String propertyName, Value<Class<?>> propertyType) {
        if (target == null) {
            throw new IllegalArgumentException("target is null");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName is null");
        }
        if (propertyType == null) {
            throw new IllegalArgumentException("propertyType is null");
        }
        this.target = target;
        this.propertyName = propertyName;
        this.propertyType = propertyType;
    }

    public LookupSetMethodValue(Value<Class<?>> target, String propertyName) {
        if (target == null) {
            throw new IllegalArgumentException("target is null");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName is null");
        }
        this.target = target;
        this.propertyName = propertyName;
        this.propertyType = null;
    }

    @Override
    public Method getValue() throws IllegalStateException {
        Class<?> targetClass = this.target.getValue();
        String propertyName = this.propertyName;
        String setterName = "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        try {
            Value<Class<?>> propertyType = this.propertyType;
            if (propertyType != null) {
                Class[] types = new Class[]{propertyType.getValue()};
                return targetClass.getMethod(setterName, types);
            }
            for (Method method : targetClass.getMethods()) {
                if (!method.getName().equals(setterName) || method.getParameterTypes().length != 1) continue;
                return method;
            }
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        throw new IllegalStateException("No such set method for property '" + propertyName + "' found on " + targetClass);
    }
}

