/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.translate;

import java.lang.reflect.Method;
import java.util.List;
import org.jboss.msc.translate.TranslationException;
import org.jboss.msc.translate.Translator;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.ThreadLocalValue;
import org.jboss.msc.value.Value;
import org.jboss.msc.value.Values;

public final class MethodTraversingTranslator<I, O>
implements Translator<I, O> {
    private final Value<Method> method;
    private final Value<?> target;
    private final List<? extends Value<?>> parameters;

    public MethodTraversingTranslator(Value<Method> method, Value<?> target, List<? extends Value<?>> parameters) {
        this.method = method;
        this.target = target;
        this.parameters = parameters;
    }

    @Override
    public O translate(I input) {
        ThreadLocalValue<Object> targetValue = Values.injectedValue();
        Value<Object> oldThis = targetValue.getAndSetValue(new ImmediateValue<I>(input));
        try {
            Object object = this.method.getValue().invoke(this.target.getValue(), Values.getValues(this.parameters));
            return (O)object;
        }
        catch (Exception e) {
            throw new TranslationException(e);
        }
        finally {
            targetValue.setValue(oldThis);
        }
    }
}

