/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.translate;

import java.lang.reflect.Constructor;
import java.util.List;
import org.jboss.msc.translate.TranslationException;
import org.jboss.msc.translate.Translator;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.ThreadLocalValue;
import org.jboss.msc.value.Value;
import org.jboss.msc.value.Values;

public final class ConstructionTranslator<I, O>
implements Translator<I, O> {
    private final Value<Constructor<? extends O>> constructor;
    private final List<? extends Value<?>> parameters;

    public ConstructionTranslator(Value<Constructor<? extends O>> constructor, List<? extends Value<?>> parameters) {
        this.constructor = constructor;
        this.parameters = parameters;
    }

    @Override
    public O translate(I input) {
        ThreadLocalValue<Object> targetValue = Values.injectedValue();
        Value<Object> oldThis = targetValue.getAndSetValue(new ImmediateValue<I>(input));
        try {
            O o = this.constructor.getValue().newInstance(Values.getValues(this.parameters));
            return o;
        }
        catch (Exception e) {
            throw new TranslationException(e);
        }
        finally {
            targetValue.setValue(oldThis);
        }
    }
}

