/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.services.http;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.lang.reflect.Method;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.inject.SetMethodInjector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.Value;
import org.jboss.msc.value.Values;

public final class HttpContextService
implements Service<HttpContext> {
    private String path;
    private HttpHandler handler;
    private HttpServer server;
    private HttpContext httpContext;
    public static final Value<Method> SERVER_SETTER = Values.getSetterMethod("server", HttpServer.class);
    public static final Value<Method> HANDLER_SETTER = Values.getSetterMethod("handler", HttpHandler.class);
    public static final Value<Method> PATH_SETTER = Values.getSetterMethod("path", String.class);
    public final Injector<HttpServer> httpServerInjector = SetMethodInjector.create(Values.immediateValue(this), SERVER_SETTER);
    public final Injector<HttpHandler> httpHandlerInjector = SetMethodInjector.create(Values.immediateValue(this), HANDLER_SETTER);
    public final Injector<String> pathInjector = SetMethodInjector.create(Values.immediateValue(this), PATH_SETTER);

    public synchronized String getPath() {
        return this.path;
    }

    public synchronized void setPath(String path) {
        this.path = path;
    }

    public synchronized HttpHandler getHandler() {
        return this.handler;
    }

    public synchronized void setHandler(HttpHandler handler) {
        this.handler = handler;
    }

    public synchronized HttpServer getServer() {
        return this.server;
    }

    public synchronized void setServer(HttpServer server) {
        this.server = server;
    }

    @Override
    public synchronized void start(StartContext context) throws StartException {
        HttpHandler handler = this.handler;
        if (handler == null) {
            throw new StartException("handler is null");
        }
        HttpServer server = this.server;
        if (server == null) {
            throw new StartException("server is null");
        }
        String path = this.path;
        if (path == null) {
            throw new StartException("path is null");
        }
        this.httpContext = server.createContext(path, handler);
    }

    @Override
    public synchronized void stop(StopContext context) {
        HttpServer server = this.server;
        HttpContext httpContext = this.httpContext;
        server.removeContext(httpContext);
        this.httpContext = null;
    }

    @Override
    public synchronized HttpContext getValue() throws IllegalStateException {
        HttpContext context = this.httpContext;
        if (context == null) {
            throw new IllegalStateException("Context not started");
        }
        return context;
    }
}

