/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.services;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.threads.JBossExecutors;

public final class ThreadPoolExecutorService
implements Service<ExecutorService> {
    private static final int DEFAULT_QUEUE_LENGTH = 100;
    private boolean allowCoreTimeout = false;
    private int corePoolSize = 10;
    private int maximumPoolSize = 40;
    private long keepAliveTime = 30L;
    private TimeUnit unit = TimeUnit.SECONDS;
    private BlockingQueue<Runnable> workQueue = new ArrayBlockingQueue<Runnable>(100);
    private ThreadFactory threadFactory = Executors.defaultThreadFactory();
    private RejectedExecutionHandler handler = new ThreadPoolExecutor.AbortPolicy();
    public static ServiceName JBOSS_THREADS = ServiceName.JBOSS.append("threads");
    public static ServiceName JBOSS_THREADS_EXECUTOR = JBOSS_THREADS.append("executor");
    private ExecutorService publicExecutor;
    private ThreadPoolExecutor realExecutor;
    private StopContext stopContext;

    public synchronized boolean isAllowCoreTimeout() {
        return this.allowCoreTimeout;
    }

    public synchronized void setAllowCoreTimeout(boolean allowCoreTimeout) {
        this.allowCoreTimeout = allowCoreTimeout;
        ThreadPoolExecutor realExecutor = this.realExecutor;
        if (realExecutor != null) {
            realExecutor.allowCoreThreadTimeOut(allowCoreTimeout);
        }
    }

    public synchronized int getCorePoolSize() {
        return this.corePoolSize;
    }

    public synchronized void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
        ThreadPoolExecutor realExecutor = this.realExecutor;
        if (realExecutor != null) {
            realExecutor.setCorePoolSize(corePoolSize);
        }
    }

    public synchronized int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public synchronized void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
        ThreadPoolExecutor realExecutor = this.realExecutor;
        if (realExecutor != null) {
            realExecutor.setMaximumPoolSize(maximumPoolSize);
        }
    }

    public synchronized long getKeepAliveTime(TimeUnit unit) {
        return unit.convert(this.keepAliveTime, this.unit);
    }

    public synchronized void setKeepAliveTime(long keepAliveTime, TimeUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("unit is null");
        }
        this.keepAliveTime = keepAliveTime;
        this.unit = unit;
        ThreadPoolExecutor realExecutor = this.realExecutor;
        if (realExecutor != null) {
            realExecutor.setKeepAliveTime(keepAliveTime, unit);
        }
    }

    public synchronized void setWorkQueue(BlockingQueue<Runnable> workQueue) {
        if (workQueue == null) {
            this.setWorkQueue(new ArrayBlockingQueue<Runnable>(100));
        }
        this.workQueue = workQueue;
    }

    public synchronized ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public synchronized void setThreadFactory(ThreadFactory threadFactory) {
        if (threadFactory == null) {
            this.setThreadFactory(Executors.defaultThreadFactory());
            return;
        }
        this.threadFactory = threadFactory;
        ThreadPoolExecutor realExecutor = this.realExecutor;
        if (realExecutor != null) {
            realExecutor.setThreadFactory(threadFactory);
        }
    }

    public synchronized RejectedExecutionHandler getHandler() {
        return this.handler;
    }

    public synchronized void setHandler(RejectedExecutionHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("handler is null");
        }
        this.handler = handler;
        ThreadPoolExecutor realExecutor = this.realExecutor;
        if (realExecutor != null) {
            realExecutor.setRejectedExecutionHandler(handler);
        }
    }

    @Override
    public synchronized ExecutorService getValue() throws IllegalStateException {
        ExecutorService publicExecutor = this.publicExecutor;
        if (publicExecutor == null) {
            throw new IllegalStateException();
        }
        return publicExecutor;
    }

    @Override
    public synchronized void start(StartContext context) throws StartException {
        this.realExecutor = new OurExecutor(this.corePoolSize, this.maximumPoolSize, this.keepAliveTime, this.unit, this.workQueue, this.threadFactory, this.handler);
        this.realExecutor.allowCoreThreadTimeOut(this.allowCoreTimeout);
        this.publicExecutor = JBossExecutors.protectedExecutorService((Executor)this.realExecutor);
    }

    @Override
    public synchronized void stop(StopContext context) {
        this.stopContext = context;
        context.asynchronous();
        this.realExecutor.shutdown();
    }

    private final class OurExecutor
    extends ThreadPoolExecutor {
        OurExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void terminated() {
            ThreadPoolExecutorService threadPoolExecutorService = ThreadPoolExecutorService.this;
            synchronized (threadPoolExecutorService) {
                StopContext context = ThreadPoolExecutorService.this.stopContext;
                if (context != null) {
                    context.complete();
                    ThreadPoolExecutorService.this.stopContext = null;
                    ThreadPoolExecutorService.this.publicExecutor = null;
                    ThreadPoolExecutorService.this.realExecutor = null;
                }
            }
        }
    }
}

