/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.services;

import java.lang.reflect.Method;
import java.util.List;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.ThreadLocalValue;
import org.jboss.msc.value.Value;
import org.jboss.msc.value.Values;

public final class LifecycleService<T>
implements Service<T> {
    private final Value<T> target;
    private final Value<Method> startMethod;
    private final List<Value<?>> startParams;
    private final Value<Method> stopMethod;
    private final List<Value<?>> stopParams;

    public LifecycleService(Value<T> target, Method startMethod, List<Value<?>> startParams, Method stopMethod, List<Value<?>> stopParams) {
        this.target = target;
        this.startMethod = startMethod == null ? Values.nullValue() : new ImmediateValue<Method>(startMethod);
        this.startParams = startParams;
        this.stopMethod = stopMethod == null ? Values.nullValue() : new ImmediateValue<Method>(stopMethod);
        this.stopParams = stopParams;
    }

    public LifecycleService(Value<T> target, Value<Method> startMethod, List<Value<?>> startParams, Value<Method> stopMethod, List<Value<?>> stopParams) {
        this.target = target;
        this.startMethod = startMethod;
        this.startParams = startParams;
        this.stopMethod = stopMethod;
        this.stopParams = stopParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(StartContext context) throws StartException {
        Method startMethod = this.startMethod.getValue();
        if (startMethod != null) {
            ThreadLocalValue<Object> thisValue = Values.thisValue();
            try {
                T target = this.target.getValue();
                Value<Object> old = thisValue.getAndSetValue(new ImmediateValue<T>(target));
                try {
                    startMethod.invoke(target, Values.getValues(this.startParams));
                }
                finally {
                    thisValue.setValue(old);
                }
            }
            catch (Exception e) {
                throw new StartException("Cannot start bean", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(StopContext context) {
        block5: {
            try {
                Method stopMethod = this.stopMethod.getValue();
                if (stopMethod == null) break block5;
                ThreadLocalValue<Object> thisValue = Values.thisValue();
                T target = this.target.getValue();
                Value<Object> old = thisValue.getAndSetValue(new ImmediateValue<T>(target));
                try {
                    stopMethod.invoke(target, Values.getValues(this.stopParams));
                }
                finally {
                    thisValue.setValue(old);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public T getValue() throws IllegalStateException {
        return this.target.getValue();
    }
}

