/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.regex.Pattern;

public final class ServiceName
implements Comparable<ServiceName>,
Serializable {
    private static final long serialVersionUID = 2336190201880964151L;
    private final String name;
    private final ServiceName parent;
    private final transient int hashCode;
    public static final ServiceName JBOSS = new ServiceName(null, "jboss");
    private static final Pattern SIMPLE_NAME = Pattern.compile("^[-_a-z@-Z0-9!#$%^&*()+=\\[\\]{}|/?<>,;:~]+$");
    private static final Field hashCodeField = AccessController.doPrivileged(new PrivilegedAction<Field>(){

        @Override
        public Field run() {
            Field field;
            try {
                field = ServiceName.class.getDeclaredField("hashCode");
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            field.setAccessible(true);
            return field;
        }
    });

    public static ServiceName of(String ... parts) {
        return ServiceName.of(null, parts);
    }

    public static ServiceName of(ServiceName parent, String ... parts) {
        if (parts.length < 1) {
            throw new IllegalArgumentException("Must provide at least one name segment");
        }
        ServiceName current = parent;
        for (String part : parts) {
            current = new ServiceName(current, part);
        }
        return current;
    }

    private ServiceName(ServiceName parent, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name;
        this.parent = parent;
        this.hashCode = ServiceName.calculateHashCode(parent, name);
    }

    private static int calculateHashCode(ServiceName parent, String name) {
        int result = parent == null ? 1 : parent.hashCode();
        result = 31 * result + name.hashCode();
        return result;
    }

    public ServiceName append(String ... parts) {
        return ServiceName.of(this, parts);
    }

    public ServiceName append(ServiceName serviceName) {
        if (serviceName.parent == null) {
            return this.append(serviceName.name);
        }
        return this.append(serviceName.parent).append(serviceName.name);
    }

    public int length() {
        ServiceName parent = this.parent;
        return parent == null ? 1 : 1 + parent.length();
    }

    public ServiceName getParent() {
        return this.parent;
    }

    public String getSimpleName() {
        return this.name;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof ServiceName && this.equals((ServiceName)o);
    }

    public boolean equals(ServiceName o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.hashCode != o.hashCode || !this.name.equals(o.name)) {
            return false;
        }
        ServiceName parent = this.parent;
        ServiceName oparent = o.parent;
        return parent != null && parent.equals(oparent) || oparent == null;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    private StringBuilder toString(StringBuilder target) {
        String name;
        ServiceName parent = this.parent;
        if (parent != null) {
            parent.toString(target);
            target.append('.');
        }
        if (SIMPLE_NAME.matcher(name = this.name).matches()) {
            target.append(name);
        } else {
            target.append('\"');
            int len = name.length();
            for (int i = 0; i < len; ++i) {
                char c = name.charAt(i);
                if (Character.isISOControl(c)) {
                    String hs = Integer.toHexString(c);
                    target.append("\\u");
                    for (int j = hs.length(); j < 4; ++j) {
                        target.append('0');
                    }
                    target.append(hs);
                    continue;
                }
                if (c == '\\' || c == '\"') {
                    target.append('\\');
                    target.append(c);
                    continue;
                }
                target.append(c);
            }
            target.append('\"');
        }
        return target;
    }

    @Override
    public int compareTo(ServiceName o) {
        int length2;
        if (o == null) {
            throw new IllegalArgumentException("o is null");
        }
        if (this == o) {
            return 0;
        }
        int length1 = this.length();
        if (length1 == (length2 = o.length())) {
            return this.compareTo(o, length1 - 1);
        }
        int diff = length1 - length2;
        if (diff > 0) {
            ServiceName x = this;
            while (diff > 0) {
                x = x.parent;
                --diff;
            }
            int res = x.compareTo(o, length2 - 1);
            return res == 0 ? 1 : res;
        }
        return -o.compareTo(this);
    }

    private int compareTo(ServiceName o, int remainingLength) {
        if (this == o) {
            return 0;
        }
        if (remainingLength == 0) {
            return this.name.compareTo(o.name);
        }
        int res = this.parent.compareTo(o.parent, remainingLength - 1);
        return res == 0 ? this.name.compareTo(o.name) : res;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        try {
            hashCodeField.setInt(this, ServiceName.calculateHashCode(this.parent, this.name));
        }
        catch (IllegalAccessException e) {
            InvalidObjectException e2 = new InvalidObjectException("Cannot set hash code field");
            e2.initCause(e);
            throw e2;
        }
    }
}

