/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.lang.reflect.Method;
import java.util.List;
import org.jboss.msc.service.DelegatingInjectionSource;
import org.jboss.msc.service.InjectionSource;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainerImpl;
import org.jboss.msc.value.ClassOfValue;
import org.jboss.msc.value.LookupMethodValue;
import org.jboss.msc.value.MethodValue;
import org.jboss.msc.value.Value;

public class MethodDelegatingInjectionSource
extends DelegatingInjectionSource {
    private final String methodName;
    private final Value<Method> methodValue;
    private final List<? extends Value<?>> parameters;
    private final List<? extends Value<Class<?>>> parameterTypes;

    public MethodDelegatingInjectionSource(InjectionSource delegate, String methodName, List<? extends Value<Class<?>>> parameterTypes, List<? extends Value<?>> parameters) {
        super(delegate);
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.parameters = parameters;
        this.methodValue = null;
    }

    public MethodDelegatingInjectionSource(InjectionSource delegate, Value<Method> methodValue, List<? extends Value<?>> parameters) {
        super(delegate);
        this.methodValue = methodValue;
        this.parameters = parameters;
        this.parameterTypes = null;
        this.methodName = null;
    }

    @Override
    protected <T> Value<?> getValue(Value<?> delegateValue, Value<T> serviceValue, ServiceBuilder<T> serviceBuilder, ServiceContainerImpl container) {
        return new MethodValue(this.getMethodValue(delegateValue), delegateValue, this.parameters);
    }

    private Value<Method> getMethodValue(Value<?> delegateValue) {
        if (this.methodValue != null) {
            return this.methodValue;
        }
        if (this.methodName == null) {
            throw new IllegalStateException("Either method name or method value must be set");
        }
        return new LookupMethodValue(new ClassOfValue(delegateValue), this.methodName, this.parameterTypes);
    }
}

