/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.lang.reflect.Field;
import org.jboss.msc.service.DelegatingInjectionSource;
import org.jboss.msc.service.InjectionSource;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainerImpl;
import org.jboss.msc.value.ClassOfValue;
import org.jboss.msc.value.FieldValue;
import org.jboss.msc.value.LookupFieldValue;
import org.jboss.msc.value.Value;

public class FieldDelegatingInjectionSource
extends DelegatingInjectionSource {
    private final Value<Field> fieldValue;
    private final String fieldName;

    public FieldDelegatingInjectionSource(InjectionSource delegate, Value<Field> fieldValue) {
        super(delegate);
        this.fieldValue = fieldValue;
        this.fieldName = null;
    }

    public FieldDelegatingInjectionSource(InjectionSource delegate, String fieldName) {
        super(delegate);
        this.fieldName = fieldName;
        this.fieldValue = null;
    }

    @Override
    protected <T> Value<?> getValue(Value<?> delegateValue, Value<T> serviceValue, ServiceBuilder<T> serviceBuilder, ServiceContainerImpl container) {
        return new FieldValue(this.getFieldValue(delegateValue), delegateValue);
    }

    private Value<Field> getFieldValue(Value<?> delegateValue) {
        if (this.fieldValue != null) {
            return this.fieldValue;
        }
        if (this.fieldName == null) {
            throw new IllegalStateException("Either field value or field name is required");
        }
        return new LookupFieldValue(new ClassOfValue(delegateValue), this.fieldName);
    }
}

