/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.msc.service.AbstractBatchBuilder;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.BatchServiceBuilderImpl;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainerImpl;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.SubBatchBuilderImpl;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

final class BatchBuilderImpl
extends AbstractBatchBuilder {
    private final Map<ServiceName, BatchServiceBuilderImpl<?>> batchServices = new HashMap();
    private final Set<SubBatchBuilderImpl> subBatchBuilders = new HashSet<SubBatchBuilderImpl>();
    private final ServiceContainerImpl container;
    private boolean done;

    BatchBuilderImpl(ServiceContainerImpl container) {
        this.container = container;
    }

    @Override
    public void install() throws ServiceRegistryException {
        if (this.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        Set<ServiceListener<Object>> batchListeners = this.getListeners();
        Set<ServiceName> batchDependencies = this.getDependencies();
        for (BatchServiceBuilderImpl<?> serviceBuilder : this.batchServices.values()) {
            serviceBuilder.addListener(batchListeners);
            serviceBuilder.addDependencies(batchDependencies);
        }
        Set<SubBatchBuilderImpl> subBatchBuilders = this.subBatchBuilders;
        for (SubBatchBuilderImpl subBatchBuilder : subBatchBuilders) {
            subBatchBuilder.reconcile();
        }
        this.done = true;
        this.container.install(this);
    }

    public <T> BatchServiceBuilderImpl<T> addServiceValue(ServiceName name, Value<? extends Service<T>> value) throws IllegalArgumentException {
        return this.createServiceBuilder(name, value, false);
    }

    private <T> BatchServiceBuilderImpl<T> createServiceBuilder(ServiceName name, Value<? extends Service<T>> value, boolean ifNotExist) throws IllegalArgumentException {
        if (this.done) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        Map<ServiceName, BatchServiceBuilderImpl<?>> batchServices = this.batchServices;
        BatchServiceBuilderImpl<?> old = batchServices.get(name);
        if (old != null && !ifNotExist) {
            throw new IllegalArgumentException("Service named " + name + " is already defined in this batch");
        }
        BatchServiceBuilderImpl builder = new BatchServiceBuilderImpl(this, value, name, ifNotExist);
        batchServices.put(name, builder);
        return builder;
    }

    @Override
    public <T> BatchServiceBuilder<T> addServiceValueIfNotExist(ServiceName name, Value<? extends Service<T>> value) throws IllegalArgumentException {
        return this.createServiceBuilder(name, value, true);
    }

    public <T> BatchServiceBuilderImpl<T> addService(ServiceName name, Service<T> service) throws IllegalArgumentException {
        return this.createServiceBuilder(name, new ImmediateValue<Service<T>>(service), false);
    }

    Map<ServiceName, BatchServiceBuilderImpl<?>> getBatchServices() {
        return this.batchServices;
    }

    @Override
    public BatchBuilder subBatchBuilder() {
        Set<SubBatchBuilderImpl> subBatches = this.subBatchBuilders;
        SubBatchBuilderImpl subBatchBuilder = new SubBatchBuilderImpl(this);
        subBatches.add(subBatchBuilder);
        return subBatchBuilder;
    }

    @Override
    boolean isDone() {
        return this.done;
    }
}

