/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.inject;

import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.reflect.Property;
import org.jboss.msc.value.Value;

public final class PropertyInjector<T>
implements Injector<T> {
    private final Value<Property> propertyValue;
    private final Value<? super T> target;

    public PropertyInjector(Value<Property> propertyValue, Value<? super T> target) {
        if (propertyValue == null) {
            throw new IllegalArgumentException("propertyValue is null");
        }
        if (target == null) {
            throw new IllegalArgumentException("target is null");
        }
        this.propertyValue = propertyValue;
        this.target = target;
    }

    @Override
    public void inject(T value) throws InjectionException {
        try {
            this.propertyValue.getValue().set(this.target.getValue(), value);
        }
        catch (Exception e) {
            throw new InjectionException("Injection failed", e);
        }
    }

    @Override
    public void uninject() {
        try {
            this.propertyValue.getValue().set(this.target.getValue(), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

