/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.modules.Module;

public abstract class ConcurrentClassLoader
extends ClassLoader {
    private static final ClassLoader definingLoader = ConcurrentClassLoader.class.getClassLoader();
    private static final ThreadLocal<Boolean> GET_PACKAGE_SUPPRESSOR = new ThreadLocal();
    protected static final Enumeration<URL> EMPTY_ENUMERATION;
    private final ConcurrentHashMap<String, Package> packages = new ConcurrentHashMap();

    protected ConcurrentClassLoader(ConcurrentClassLoader parent) {
        super(parent == null ? ConcurrentClassLoader.class.getClassLoader() : parent);
        if (this.getClassLoadingLock("$TEST$") == this) {
            throw new Error("Cannot instantiate non-parallel subclass");
        }
    }

    protected ConcurrentClassLoader() {
        super(ConcurrentClassLoader.class.getClassLoader());
        if (this.getClassLoadingLock("$TEST$") == this) {
            throw new Error("Cannot instantiate non-parallel subclass");
        }
    }

    @Override
    public final Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.performLoadClass(className, false, false);
    }

    @Override
    public final Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        return this.performLoadClass(className, false, resolve);
    }

    public final Class<?> loadExportedClass(String className) throws ClassNotFoundException {
        return this.performLoadClass(className, true, false);
    }

    public final Class<?> loadExportedClass(String className, boolean resolve) throws ClassNotFoundException {
        return this.performLoadClass(className, true, resolve);
    }

    protected Class<?> findClass(String className, boolean exportsOnly, boolean resolve) throws ClassNotFoundException {
        throw new ClassNotFoundException(className);
    }

    protected final Class<?> defineOrLoadClass(String className, byte[] bytes, int off, int len) {
        try {
            Class<?> definedClass = this.defineClass(className, bytes, off, len);
            return definedClass;
        }
        catch (LinkageError e) {
            Class<?> loadedClass = this.findLoadedClass(className);
            if (loadedClass != null) {
                return loadedClass;
            }
            throw e;
        }
    }

    protected final Class<?> defineOrLoadClass(String className, byte[] bytes, int off, int len, ProtectionDomain protectionDomain) {
        try {
            Class<?> definedClass = this.defineClass(className, bytes, off, len, protectionDomain);
            return definedClass;
        }
        catch (LinkageError e) {
            Class<?> loadedClass = this.findLoadedClass(className);
            if (loadedClass != null) {
                return loadedClass;
            }
            throw e;
        }
    }

    @Override
    protected final Class<?> findClass(String className) throws ClassNotFoundException {
        return this.findClass(className, false, false);
    }

    @Override
    public final URL getResource(String name) {
        for (String s : Module.systemPaths) {
            if (!name.startsWith(s)) continue;
            return definingLoader != null ? definingLoader.getResource(name) : ClassLoader.getSystemResource(name);
        }
        return this.findResource(name, false);
    }

    @Override
    public final Enumeration<URL> getResources(String name) throws IOException {
        for (String s : Module.systemPaths) {
            if (!name.startsWith(s)) continue;
            return definingLoader != null ? definingLoader.getResources(name) : ClassLoader.getSystemResources(name);
        }
        return this.findResources(name, false);
    }

    protected URL findResource(String name, boolean exportsOnly) {
        return null;
    }

    @Override
    protected final URL findResource(String name) {
        return null;
    }

    protected Enumeration<URL> findResources(String name, boolean exportsOnly) throws IOException {
        return EMPTY_ENUMERATION;
    }

    @Override
    protected final Enumeration<URL> findResources(String name) {
        return EMPTY_ENUMERATION;
    }

    protected InputStream findResourceAsStream(String name, boolean exportsOnly) {
        URL url = this.findResource(name, exportsOnly);
        try {
            return url == null ? null : url.openStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public final InputStream getResourceAsStream(String name) {
        for (String s : Module.systemPaths) {
            if (!name.startsWith(s)) continue;
            return definingLoader != null ? definingLoader.getResourceAsStream(name) : ClassLoader.getSystemResourceAsStream(name);
        }
        return this.findResourceAsStream(name, false);
    }

    private Class<?> performLoadClass(String className, boolean exportsOnly, boolean resolve) throws ClassNotFoundException {
        if (className == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (className.length() == 0) {
            throw new IllegalArgumentException("name is empty");
        }
        for (String s : Module.systemPackages) {
            if (!className.startsWith(s)) continue;
            return definingLoader != null ? definingLoader.loadClass(className) : this.findSystemClass(className);
        }
        return this.performLoadClassUnchecked(className, exportsOnly, resolve);
    }

    private Class<?> performLoadClassUnchecked(String className, boolean exportsOnly, boolean resolve) throws ClassNotFoundException {
        if (className.charAt(0) == '[') {
            Class<?> array = Class.forName(className, false, this);
            if (resolve) {
                this.resolveClass(array);
            }
            return array;
        }
        return this.findClass(className, exportsOnly, resolve);
    }

    @Override
    protected final Package getPackage(String name) {
        String packageName = name + ".";
        for (String s : Module.systemPackages) {
            if (!packageName.startsWith(s)) continue;
            return Package.getPackage(name);
        }
        if (GET_PACKAGE_SUPPRESSOR.get() == Boolean.TRUE) {
            return null;
        }
        return this.getPackageByName(name);
    }

    protected Package getPackageByName(String name) {
        Package parentPackage = super.getPackage(name);
        return parentPackage == null ? this.findLoadedPackage(name) : parentPackage;
    }

    @Override
    protected Package[] getPackages() {
        ArrayList<Package> list = new ArrayList<Package>();
        list.addAll(this.packages.values());
        list.addAll(Arrays.asList(super.getPackages()));
        return list.toArray(new Package[list.size()]);
    }

    protected final Package findLoadedPackage(String name) {
        return this.packages.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Package definePackage(String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) throws IllegalArgumentException {
        ThreadLocal<Boolean> suppressor = GET_PACKAGE_SUPPRESSOR;
        suppressor.set(Boolean.TRUE);
        try {
            Package existing = this.packages.get(name);
            if (existing != null) {
                Package package_ = existing;
                return package_;
            }
            Package pkg = super.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
            existing = this.packages.putIfAbsent(name, pkg);
            Package package_ = existing != null ? existing : pkg;
            return package_;
        }
        finally {
            suppressor.remove();
        }
    }

    static {
        if (!ClassLoader.registerAsParallelCapable()) {
            throw new Error("Failed to register " + ConcurrentClassLoader.class.getName() + " as parallel-capable");
        }
        Package.getPackages();
        EMPTY_ENUMERATION = Collections.enumeration(Collections.emptySet());
    }
}

