/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.File;
import org.jboss.modules.DelegatingModuleLoader;
import org.jboss.modules.LocalModuleFinder;
import org.jboss.modules.ModuleFinder;
import org.jboss.modules.Utils;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;

public final class LocalModuleLoader
extends DelegatingModuleLoader
implements AutoCloseable {
    public LocalModuleLoader(File[] repoRoots) {
        this(repoRoots, PathFilters.acceptAll());
    }

    public LocalModuleLoader(File[] repoRoots, PathFilter pathFilter) {
        super(Utils.JDK_MODULE_LOADER, new ModuleFinder[]{new LocalModuleFinder(repoRoots, pathFilter)});
    }

    public LocalModuleLoader() {
        super(Utils.JDK_MODULE_LOADER, new ModuleFinder[]{new LocalModuleFinder()});
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("local module loader @").append(Integer.toHexString(this.hashCode())).append(" (finder: ").append(this.getFinders()[0]).append(')');
        return b.toString();
    }

    @Override
    public void close() {
        ModuleFinder[] finders = this.getFinders();
        assert (finders.length == 1 && finders[0] instanceof LocalModuleFinder);
        ((LocalModuleFinder)finders[0]).close();
    }
}

