/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.IOException;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.modules.PackageSpec;
import org.jboss.modules.ResourceLoader;

public abstract class AbstractResourceLoader
implements ResourceLoader {
    private static String getDefinedAttribute(Attributes.Name name, Attributes entryAttribute, Attributes mainAttribute) {
        String value;
        String string = value = entryAttribute == null ? null : entryAttribute.getValue(name);
        return value == null ? (mainAttribute == null ? null : mainAttribute.getValue(name)) : value;
    }

    protected static PackageSpec getPackageSpec(String name, Manifest manifest, URL rootUrl) throws IOException {
        PackageSpec spec = new PackageSpec();
        if (manifest == null) {
            return null;
        }
        Attributes mainAttribute = manifest.getMainAttributes();
        String path = name.replace('.', '/').concat("/");
        Attributes entryAttribute = manifest.getAttributes(path);
        if (entryAttribute == null || entryAttribute.isEmpty()) {
            return null;
        }
        spec.setSpecTitle(AbstractResourceLoader.getDefinedAttribute(Attributes.Name.SPECIFICATION_TITLE, entryAttribute, mainAttribute));
        spec.setSpecVersion(AbstractResourceLoader.getDefinedAttribute(Attributes.Name.SPECIFICATION_VERSION, entryAttribute, mainAttribute));
        spec.setSpecVendor(AbstractResourceLoader.getDefinedAttribute(Attributes.Name.SPECIFICATION_VENDOR, entryAttribute, mainAttribute));
        spec.setImplTitle(AbstractResourceLoader.getDefinedAttribute(Attributes.Name.IMPLEMENTATION_TITLE, entryAttribute, mainAttribute));
        spec.setImplVersion(AbstractResourceLoader.getDefinedAttribute(Attributes.Name.IMPLEMENTATION_VERSION, entryAttribute, mainAttribute));
        spec.setImplVendor(AbstractResourceLoader.getDefinedAttribute(Attributes.Name.IMPLEMENTATION_VENDOR, entryAttribute, mainAttribute));
        if (Boolean.parseBoolean(AbstractResourceLoader.getDefinedAttribute(Attributes.Name.SEALED, entryAttribute, mainAttribute))) {
            spec.setSealBase(rootUrl);
        }
        return spec;
    }
}

