/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.Serializable;
import java.util.regex.Pattern;

public final class ModuleIdentifier
implements Serializable {
    private static final long serialVersionUID = 118533026624827995L;
    private static Pattern MODULE_NAME_PATTERN = Pattern.compile("[a-zA-Z_][-a-zA-Z0-9_]*(?:\\.[a-zA-Z0-9_][-a-zA-Z0-9_]*)*");
    private static Pattern SLOT_PATTERN = Pattern.compile("[-a-zA-Z0-9_+*.]+");
    private static String DEFAULT_SLOT = "main";
    private final String name;
    private final String slot;
    private int hash = 0;
    public static final ModuleIdentifier SYSTEM = new ModuleIdentifier("system", DEFAULT_SLOT);

    private ModuleIdentifier(String name, String slot) {
        this.name = name;
        this.slot = slot;
    }

    public String getName() {
        return this.name;
    }

    public String getSlot() {
        return this.slot;
    }

    public boolean equals(Object o) {
        return o instanceof ModuleIdentifier && this.equals((ModuleIdentifier)o);
    }

    public boolean equals(ModuleIdentifier o) {
        return this == o || o != null && this.name.equals(o.name) && this.slot.equals(o.slot);
    }

    public int hashCode() {
        if (this.hash == 0) {
            int h = 17;
            h = 37 * h + this.name.hashCode();
            this.hash = h = 37 * h + this.slot.hashCode();
        }
        return this.hash;
    }

    public String toString() {
        return "module:" + this.toSpecString();
    }

    public static ModuleIdentifier fromString(String moduleSpec) throws IllegalArgumentException {
        String slot;
        String name;
        if (moduleSpec == null) {
            throw new IllegalArgumentException("Module specification is null");
        }
        if (moduleSpec.length() == 0) {
            throw new IllegalArgumentException("Empty module specificiation");
        }
        int c1 = moduleSpec.lastIndexOf(58);
        if (c1 != -1) {
            name = moduleSpec.substring(0, c1);
            slot = moduleSpec.substring(c1 + 1);
            if (!SLOT_PATTERN.matcher(slot).matches()) {
                throw new IllegalArgumentException("Slot has invalid characters or is empty");
            }
        } else {
            name = moduleSpec;
            slot = DEFAULT_SLOT;
        }
        if (!MODULE_NAME_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException("Module name contains invalid characters, or empty segments");
        }
        return new ModuleIdentifier(name, slot);
    }

    private String toSpecString() {
        return this.name + ":" + this.slot;
    }

    public static ModuleIdentifier create(String name, String slot) {
        if (name == null) {
            throw new IllegalArgumentException("Name can not be null");
        }
        if (slot == null) {
            slot = DEFAULT_SLOT;
        }
        return new ModuleIdentifier(name, slot);
    }

    public static ModuleIdentifier create(String name) {
        return ModuleIdentifier.create(name, null);
    }
}

