/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.modules.Main;
import org.jboss.modules.ModuleLogger;

public final class JDKModuleLogger
implements ModuleLogger {
    private static final Level TRACE;
    private final Logger logger;

    public JDKModuleLogger(Logger logger) {
        this.logger = logger;
    }

    public JDKModuleLogger(String category) {
        this(Logger.getLogger(category));
    }

    public JDKModuleLogger() {
        this("org.jboss.modules");
    }

    @Override
    public void trace(String message) {
        this.logger.log(TRACE, message);
    }

    @Override
    public void trace(String format, Object arg1) {
        if (this.logger.isLoggable(TRACE)) {
            this.logger.log(TRACE, String.format(format, arg1));
        }
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        if (this.logger.isLoggable(TRACE)) {
            this.logger.log(TRACE, String.format(format, arg1, arg2));
        }
    }

    @Override
    public void trace(String format, Object arg1, Object arg2, Object arg3) {
        if (this.logger.isLoggable(TRACE)) {
            this.logger.log(TRACE, String.format(format, arg1, arg2, arg3));
        }
    }

    @Override
    public void trace(String format, Object ... args) {
        if (this.logger.isLoggable(TRACE)) {
            this.logger.log(TRACE, String.format(format, args));
        }
    }

    @Override
    public void trace(Throwable t, String message) {
        this.logger.log(TRACE, message, t);
    }

    @Override
    public void trace(Throwable t, String format, Object arg1) {
        if (this.logger.isLoggable(TRACE)) {
            this.logger.log(TRACE, String.format(format, arg1), t);
        }
    }

    @Override
    public void trace(Throwable t, String format, Object arg1, Object arg2) {
        if (this.logger.isLoggable(TRACE)) {
            this.logger.log(TRACE, String.format(format, arg1, arg2), t);
        }
    }

    @Override
    public void trace(Throwable t, String format, Object arg1, Object arg2, Object arg3) {
        if (this.logger.isLoggable(TRACE)) {
            this.logger.log(TRACE, String.format(format, arg1, arg2, arg3), t);
        }
    }

    @Override
    public void trace(Throwable t, String format, Object ... args) {
        if (this.logger.isLoggable(TRACE)) {
            this.logger.log(TRACE, String.format(format, args), t);
        }
    }

    @Override
    public void greeting() {
        this.logger.log(Level.INFO, "JBoss Modules version " + Main.getVersionString());
    }

    static {
        Level level = null;
        try {
            level = Level.parse("TRACE");
        }
        catch (IllegalArgumentException ignored) {
            level = Level.FINEST;
        }
        TRACE = level;
    }
}

