/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.modules.AssertionSetting;
import org.jboss.modules.ClassSpec;
import org.jboss.modules.ConcurrentClassLoader;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLogger;
import org.jboss.modules.PackageSpec;
import org.jboss.modules.PathFilter;
import org.jboss.modules.Paths;
import org.jboss.modules.Resource;
import org.jboss.modules.ResourceLoader;

public class ModuleClassLoader
extends ConcurrentClassLoader {
    static final ResourceLoader[] NO_RESOURCE_LOADERS;
    private final Module module;
    private volatile Paths<ResourceLoader, ResourceLoader> paths;
    private final LocalLoader localLoader = new LocalLoader(){

        @Override
        public Class<?> loadClassLocal(String name, boolean resolve) {
            try {
                return ModuleClassLoader.this.loadClassLocal(name, false, resolve);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        @Override
        public List<Resource> loadResourceLocal(String name) {
            return ModuleClassLoader.this.loadResourceLocal(name, false);
        }

        @Override
        public Resource loadResourceLocal(String root, String name) {
            return ModuleClassLoader.this.loadResourceLocal(root, name, false);
        }
    };
    private final PathFilter exportPathFilter = new PathFilter(){

        @Override
        public boolean accept(String path) {
            return ModuleClassLoader.this.paths.getExportedPaths().containsKey(path);
        }
    };
    private static final AtomicReferenceFieldUpdater<ModuleClassLoader, Paths<ResourceLoader, ResourceLoader>> pathsUpdater;

    private static <A, B> AtomicReferenceFieldUpdater<A, B> unsafeCast(AtomicReferenceFieldUpdater<?, ?> updater) {
        return updater;
    }

    protected ModuleClassLoader(Configuration configuration) {
        this.module = configuration.getModule();
        this.paths = new Paths(configuration.getResourceLoaders(), Collections.emptyMap(), Collections.emptyMap());
        AssertionSetting setting = configuration.getAssertionSetting();
        if (setting != AssertionSetting.INHERIT) {
            this.setDefaultAssertionStatus(setting == AssertionSetting.ENABLED);
        }
    }

    boolean recalculate() {
        Paths<ResourceLoader, ResourceLoader> paths = this.paths;
        return this.setResourceLoaders(paths, paths.getSourceList((ResourceLoader[])NO_RESOURCE_LOADERS));
    }

    boolean setResourceLoaders(ResourceLoader[] resourceLoaders) {
        return this.setResourceLoaders(this.paths, resourceLoaders);
    }

    private boolean setResourceLoaders(Paths<ResourceLoader, ResourceLoader> paths, ResourceLoader[] resourceLoaders) {
        HashMap exportedPaths = new HashMap();
        HashMap allPaths = new HashMap();
        for (ResourceLoader loader : resourceLoaders) {
            PathFilter exportFilter = loader.getExportFilter();
            for (String path : loader.getPaths()) {
                List allLoaders = (List)allPaths.get(path);
                if (allLoaders == null) {
                    allPaths.put(path, new ArrayList<ResourceLoader>(Collections.singleton(loader)));
                } else {
                    allLoaders.add(loader);
                }
                if (!exportFilter.accept(path)) continue;
                List exportedLoaders = (List)exportedPaths.get(path);
                if (exportedLoaders == null) {
                    exportedPaths.put(path, new ArrayList<ResourceLoader>(Collections.singleton(loader)));
                    continue;
                }
                exportedLoaders.add(loader);
            }
        }
        return pathsUpdater.compareAndSet(this, paths, new Paths(resourceLoaders, allPaths, exportedPaths));
    }

    LocalLoader getLocalLoader() {
        return this.localLoader;
    }

    PathFilter getExportPathFilter() {
        return this.exportPathFilter;
    }

    @Override
    protected final Class<?> findClass(String className, boolean exportsOnly, boolean resolve) throws ClassNotFoundException {
        Class<?> loadedClass = this.findLoadedClass(className);
        if (loadedClass != null) {
            return loadedClass;
        }
        ModuleLogger log = Module.log;
        Module module = this.module;
        log.trace("Finding class %s from %s", (Object)className, (Object)module);
        Class<?> clazz = module.loadModuleClass(className, exportsOnly, resolve);
        if (clazz != null) {
            return clazz;
        }
        log.trace("Class %s not found from %s", (Object)className, (Object)module);
        throw new ClassNotFoundException(className + " from [" + module + "]");
    }

    Class<?> loadClassLocal(String className, boolean exportOnly, boolean resolve) throws ClassNotFoundException {
        ModuleLogger log = Module.log;
        Module module = this.module;
        log.trace("Finding local class %s from %s", (Object)className, (Object)module);
        Class<?> loadedClass = this.findLoadedClass(className);
        if (loadedClass != null) {
            log.trace("Found previously loaded %s from %s", (Object)loadedClass, (Object)module);
            return loadedClass;
        }
        Map<String, List<ResourceLoader>> paths = this.paths.getPaths(exportOnly);
        log.trace("Loading class %s locally from %s", (Object)className, (Object)module);
        String path = Module.pathOfClass(className);
        List<ResourceLoader> loaders = paths.get(path);
        if (loaders == null) {
            return null;
        }
        ClassSpec classSpec = null;
        try {
            ResourceLoader loader;
            Iterator<ResourceLoader> i$ = loaders.iterator();
            while (i$.hasNext() && (classSpec = (loader = i$.next()).getClassSpec(className)) == null) {
            }
        }
        catch (IOException e) {
            throw new ClassNotFoundException(className, e);
        }
        catch (RuntimeException e) {
            log.trace(e, "Unexpected runtime exception in module loader");
            throw new ClassNotFoundException(className, e);
        }
        catch (Error e) {
            log.trace(e, "Unexpected error in module loader");
            throw new ClassNotFoundException(className, e);
        }
        if (classSpec == null) {
            log.trace("No local specification found for class %s in %s", (Object)className, (Object)module);
            return null;
        }
        Class<?> clazz = this.defineClass(className, classSpec);
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    Resource loadResourceLocal(String root, String name, boolean exportsOnly) {
        String path;
        Map<String, List<ResourceLoader>> paths = this.paths.getPaths(exportsOnly);
        List<ResourceLoader> loaders = paths.get(path = Module.pathOf(name));
        if (loaders == null) {
            return null;
        }
        for (ResourceLoader loader : loaders) {
            if (!root.equals(loader.getRootName())) continue;
            return loader.getResource(name);
        }
        return null;
    }

    List<Resource> loadResourceLocal(String name, boolean exportsOnly) {
        String path;
        Map<String, List<ResourceLoader>> paths = this.paths.getPaths(exportsOnly);
        List<ResourceLoader> loaders = paths.get(path = Module.pathOf(name));
        if (loaders == null) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList(loaders.size());
        for (ResourceLoader loader : loaders) {
            Resource resource = loader.getResource(name);
            if (resource == null) continue;
            list.add(resource);
        }
        return list.isEmpty() ? Collections.emptyList() : list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> defineClass(String name, ClassSpec classSpec) {
        Class<?> newClass;
        ModuleLogger log = Module.log;
        Module module = this.module;
        log.trace("Attempting to define class %s in %s", (Object)name, (Object)module);
        int lastIdx = name.lastIndexOf(46);
        if (lastIdx != -1) {
            String packageName = name.substring(0, lastIdx);
            ModuleClassLoader moduleClassLoader = this;
            synchronized (moduleClassLoader) {
                Package pkg = this.getPackage(packageName);
                if (pkg != null) {
                    if (pkg.isSealed() && !pkg.isSealed(classSpec.getCodeSource().getLocation())) {
                        log.trace("Detected a sealing violation (attempt to define class %s in sealed package %s in %s)", (Object)name, (Object)packageName, (Object)module);
                        throw new SecurityException("sealing violation: package " + packageName + " is sealed");
                    }
                } else {
                    String path;
                    Map<String, List<ResourceLoader>> paths = this.paths.getAllPaths();
                    List<ResourceLoader> loaders = paths.get(path = Module.pathOf(name));
                    if (loaders != null) {
                        PackageSpec spec = null;
                        for (ResourceLoader loader : loaders) {
                            try {
                                spec = loader.getPackageSpec(name);
                                if (spec == null) continue;
                                break;
                            }
                            catch (IOException e) {
                            }
                        }
                        if (spec != null) {
                            this.definePackage(packageName, spec);
                        } else {
                            this.definePackage(packageName, null);
                        }
                    } else {
                        this.definePackage(packageName, null);
                    }
                }
            }
        }
        try {
            byte[] bytes = classSpec.getBytes();
            try {
                newClass = this.defineClass(name, bytes, 0, bytes.length, classSpec.getCodeSource());
            }
            catch (NoClassDefFoundError e) {
                LinkageError ne = new LinkageError("Failed to link " + name.replace('.', '/') + " (" + module + ")");
                ne.initCause(e);
                throw ne;
            }
            catch (LinkageError e) {
                log.trace(e, "Encountered linkage error; attempting to recover");
                Class<?> loadedClass = this.findLoadedClass(name);
                if (loadedClass != null) {
                    return loadedClass;
                }
                throw e;
            }
        }
        catch (Error e) {
            log.trace((Throwable)e, "Failed to define class %s in %s", (Object)name, (Object)module);
            throw e;
        }
        catch (RuntimeException e) {
            log.trace((Throwable)e, "Failed to define class %s in %s", (Object)name, (Object)module);
            throw e;
        }
        AssertionSetting setting = classSpec.getAssertionSetting();
        if (setting != AssertionSetting.INHERIT) {
            this.setClassAssertionStatus(name, setting == AssertionSetting.ENABLED);
        }
        return newClass;
    }

    private Package definePackage(String name, PackageSpec spec) {
        Package pkg;
        Module module = this.module;
        ModuleLogger log = Module.log;
        log.trace("Attempting to define package %s in %s", (Object)name, (Object)module);
        if (spec == null) {
            pkg = this.definePackage(name, null, null, null, null, null, null, null);
        } else {
            pkg = this.definePackage(name, spec.getSpecTitle(), spec.getSpecVersion(), spec.getSpecVendor(), spec.getImplTitle(), spec.getImplVersion(), spec.getImplVendor(), spec.getSealBase());
            AssertionSetting setting = spec.getAssertionSetting();
            if (setting != AssertionSetting.INHERIT) {
                this.setPackageAssertionStatus(name, setting == AssertionSetting.ENABLED);
            }
        }
        log.trace("Defined package %s in %s", (Object)name, (Object)module);
        return pkg;
    }

    @Override
    protected final String findLibrary(String libname) {
        ModuleLogger log = Module.log;
        log.trace("Attempting to load native library %s from %s", (Object)libname, (Object)this.module);
        for (ResourceLoader loader : this.paths.getSourceList((ResourceLoader[])NO_RESOURCE_LOADERS)) {
            String library = loader.getLibrary(libname);
            if (library == null) continue;
            return library;
        }
        return null;
    }

    @Override
    public final URL findResource(String name, boolean exportsOnly) {
        return this.module.getResource(name, exportsOnly);
    }

    @Override
    public final Enumeration<URL> findResources(String name, boolean exportsOnly) throws IOException {
        return this.module.getResources(name, exportsOnly);
    }

    @Override
    public final InputStream findResourceAsStream(String name, boolean exportsOnly) {
        try {
            URL resource = this.findResource(name, exportsOnly);
            return resource == null ? null : resource.openStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    public final Module getModule() {
        return this.module;
    }

    public final String toString() {
        return "ClassLoader for " + this.module;
    }

    Set<String> getPaths() {
        return this.paths.getAllPaths().keySet();
    }

    @Override
    protected final PermissionCollection getPermissions(CodeSource codesource) {
        return super.getPermissions(codesource);
    }

    @Override
    protected final Package definePackage(String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) throws IllegalArgumentException {
        return super.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    @Override
    protected final Package getPackage(String name) {
        return super.getPackage(name);
    }

    @Override
    protected final Package[] getPackages() {
        return super.getPackages();
    }

    @Override
    public final void setDefaultAssertionStatus(boolean enabled) {
        super.setDefaultAssertionStatus(enabled);
    }

    @Override
    public final void setPackageAssertionStatus(String packageName, boolean enabled) {
        super.setPackageAssertionStatus(packageName, enabled);
    }

    @Override
    public final void setClassAssertionStatus(String className, boolean enabled) {
        super.setClassAssertionStatus(className, enabled);
    }

    @Override
    public final void clearAssertionStatus() {
        super.clearAssertionStatus();
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    protected final Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected final void finalize() throws Throwable {
        super.finalize();
    }

    static {
        try {
            Method method = ClassLoader.class.getMethod("registerAsParallelCapable", new Class[0]);
            method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        NO_RESOURCE_LOADERS = new ResourceLoader[0];
        pathsUpdater = ModuleClassLoader.unsafeCast(AtomicReferenceFieldUpdater.newUpdater(ModuleClassLoader.class, Paths.class, "paths"));
    }

    protected static final class Configuration {
        private final Module module;
        private final AssertionSetting assertionSetting;
        private final ResourceLoader[] resourceLoaders;

        Configuration(Module module, AssertionSetting assertionSetting, ResourceLoader[] resourceLoaders) {
            this.module = module;
            this.assertionSetting = assertionSetting;
            this.resourceLoaders = resourceLoaders;
        }

        Module getModule() {
            return this.module;
        }

        AssertionSetting getAssertionSetting() {
            return this.assertionSetting;
        }

        ResourceLoader[] getResourceLoaders() {
            return this.resourceLoaders;
        }
    }
}

