/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly8;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jboss.migration.core.AbstractServerProvider;
import org.jboss.migration.core.ProductInfo;
import org.jboss.migration.core.Server;
import org.jboss.migration.core.ServerMigrationFailureException;
import org.jboss.migration.core.env.MigrationEnvironment;
import org.jboss.migration.core.jboss.JBossServer;
import org.jboss.migration.core.jboss.ModuleIdentifier;
import org.jboss.migration.wfly8.WildFlyServer8;

public class WildFlyServerProvider8
extends AbstractServerProvider {
    protected ProductInfo getProductInfo(Path baseDir, MigrationEnvironment migrationEnvironment) throws IllegalArgumentException, ServerMigrationFailureException {
        JBossServer.Module module = new JBossServer.Modules(baseDir).getModule("org.jboss.as.version");
        if (module == null) {
            return null;
        }
        Path versionModuleMainDirPath = new JBossServer.Modules(baseDir).getModuleDir(ModuleIdentifier.fromString((String)"org.jboss.as.version"));
        if (!Files.isDirectory(versionModuleMainDirPath, new LinkOption[0])) {
            return null;
        }
        class FileVisitor
        extends SimpleFileVisitor<Path> {
            private ProductInfo productInfo = null;

            FileVisitor() {
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String fileName = file.getFileName().toString();
                if (fileName.startsWith("wildfly-version-") && fileName.endsWith(".jar")) {
                    JarFile jarFile = new JarFile(file.toFile());
                    Manifest manifest = jarFile.getManifest();
                    String productName = null;
                    if ("WildFly: Version".equals(manifest.getMainAttributes().getValue("Implementation-Title"))) {
                        productName = "WildFly";
                    }
                    if (productName == null) {
                        throw new IllegalArgumentException();
                    }
                    String productVersion = manifest.getMainAttributes().getValue("Implementation-Version");
                    if (productVersion == null) {
                        throw new IllegalArgumentException();
                    }
                    this.productInfo = new ProductInfo(productName.trim(), productVersion.trim());
                    return FileVisitResult.TERMINATE;
                }
                return FileVisitResult.CONTINUE;
            }
        }
        FileVisitor fileVisitor = new FileVisitor();
        try {
            Files.walkFileTree(versionModuleMainDirPath, fileVisitor);
        }
        catch (IOException e) {
            throw new ServerMigrationFailureException("failed to retrieve product info", (Throwable)e);
        }
        return fileVisitor.productInfo;
    }

    protected String getProductNameRegex() {
        return "WildFly";
    }

    protected String getProductVersionRegex() {
        return "8\\..*";
    }

    protected Server constructServer(String migrationName, ProductInfo productInfo, Path baseDir, MigrationEnvironment migrationEnvironment) {
        return new WildFlyServer8(migrationName, productInfo, baseDir, migrationEnvironment);
    }

    public String getName() {
        return "WildFly 8.x";
    }
}

