/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly8;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jboss.migration.core.AbstractServerProvider;
import org.jboss.migration.core.JBossServer;
import org.jboss.migration.core.ProductInfo;
import org.jboss.migration.core.Server;
import org.jboss.migration.core.env.MigrationEnvironment;
import org.jboss.migration.wfly8.WildFly8Server;

public class WildFly8ServerProvider
extends AbstractServerProvider {
    protected ProductInfo getProductInfo(Path baseDir, MigrationEnvironment migrationEnvironment) throws IllegalArgumentException, IOException {
        Path versionModuleMainDirPath = JBossServer.getModulesDir((Path)baseDir).resolve("system").resolve("layers").resolve("base").resolve("org").resolve("jboss").resolve("as").resolve("version").resolve("main");
        if (!Files.isDirectory(versionModuleMainDirPath, new LinkOption[0])) {
            return null;
        }
        class FileVisitor
        extends SimpleFileVisitor<Path> {
            private ProductInfo productInfo = null;

            FileVisitor() {
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String fileName = file.getFileName().toString();
                if (fileName.startsWith("wildfly-version-") && fileName.endsWith(".jar")) {
                    JarFile jarFile = new JarFile(file.toFile());
                    Manifest manifest = jarFile.getManifest();
                    String productName = null;
                    if ("WildFly: Version".equals(manifest.getMainAttributes().getValue("Implementation-Title"))) {
                        productName = "WildFly";
                    }
                    if (productName == null) {
                        throw new IllegalArgumentException();
                    }
                    String productVersion = manifest.getMainAttributes().getValue("Implementation-Version");
                    if (productVersion == null) {
                        throw new IllegalArgumentException();
                    }
                    this.productInfo = new ProductInfo(productName.trim(), productVersion.trim());
                    return FileVisitResult.TERMINATE;
                }
                return FileVisitResult.CONTINUE;
            }
        }
        FileVisitor fileVisitor = new FileVisitor();
        Files.walkFileTree(versionModuleMainDirPath, fileVisitor);
        return fileVisitor.productInfo;
    }

    protected String getProductNameRegex() {
        return "WildFly";
    }

    protected String getProductVersionRegex() {
        return "8\\..*";
    }

    protected Server constructServer(String migrationName, ProductInfo productInfo, Path baseDir, MigrationEnvironment migrationEnvironment) {
        return new WildFly8Server(migrationName, productInfo, baseDir, migrationEnvironment);
    }

    public String getName() {
        return "WildFly 8.x";
    }
}

