/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly8;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jboss.migration.core.AbstractServer;
import org.jboss.migration.core.ProductInfo;
import org.jboss.migration.core.Server;
import org.jboss.migration.core.ServerPath;

public class WildFly8Server
extends AbstractServer {
    public WildFly8Server(ProductInfo productInfo, Path baseDir) {
        super(productInfo, baseDir);
    }

    public Collection<ServerPath<WildFly8Server>> getStandaloneConfigs() {
        ArrayList<ServerPath> standaloneConfigs = new ArrayList<ServerPath>();
        Path standaloneConfigurationDir = this.getStandaloneConfigurationDir();
        standaloneConfigs.add(new ServerPath(standaloneConfigurationDir.resolve("standalone.xml"), (Server)this));
        standaloneConfigs.add(new ServerPath(standaloneConfigurationDir.resolve("standalone-ha.xml"), (Server)this));
        standaloneConfigs.add(new ServerPath(standaloneConfigurationDir.resolve("standalone-full.xml"), (Server)this));
        standaloneConfigs.add(new ServerPath(standaloneConfigurationDir.resolve("standalone-full-ha.xml"), (Server)this));
        return Collections.unmodifiableList(standaloneConfigs);
    }

    public Path getStandaloneDir() {
        return this.getBaseDir().resolve("standalone");
    }

    public Path getStandaloneConfigurationDir() {
        return this.getStandaloneDir().resolve("configuration");
    }

    public Path getModulesDir() {
        return WildFly8Server.getModulesDir(this.getBaseDir());
    }

    public Path getModulesSystemLayersBaseDir() {
        return WildFly8Server.getModulesSystemLayersBaseDir(this.getBaseDir());
    }

    public static Path getModulesDir(Path baseDir) {
        return baseDir.resolve("modules");
    }

    public static Path getModulesSystemLayersBaseDir(Path baseDir) {
        return WildFly8Server.getModulesDir(baseDir).resolve("system").resolve("layers").resolve("base");
    }
}

