/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem.singleton;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.SubsystemResource;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceBuildParameters;
import org.jboss.migration.wfly10.config.task.management.subsystem.AddSubsystemResourceSubtaskBuilder;

public class AddSingletonSubsystemResource<S>
extends AddSubsystemResourceSubtaskBuilder<S> {
    private static final String DEFAULT_ATTR_NAME = "default";
    private static final String DEFAULT_ATTR_VALUE = "default";
    private static final String SINGLETON_POLICY = "singleton-policy";
    private static final String CACHE_CONTAINER_ATTR_NAME = "cache-container";
    private static final String CACHE_CONTAINER_ATTR_VALUE = "server";
    private static final String ELECTION_POLICY = "election-policy";
    private static final String ELECTION_POLICY_NAME = "simple";

    protected AddSingletonSubsystemResource() {
        super("singleton");
    }

    @Override
    protected void addConfiguration(ManageableResourceBuildParameters<S, SubsystemResource.Parent> params, TaskContext taskContext) {
        SubsystemResource.Parent parentResource = params.getResource();
        ManageableServerConfiguration serverConfiguration = parentResource.getServerConfiguration();
        Operations.CompositeOperationBuilder compositeOperationBuilder = Operations.CompositeOperationBuilder.create();
        PathAddress subsystemPathAddress = parentResource.getSubsystemResourcePathAddress(this.getSubsystem());
        ModelNode subsystemAddOperation = Util.createAddOperation((PathAddress)subsystemPathAddress);
        subsystemAddOperation.get("default").set("default");
        compositeOperationBuilder.addStep(subsystemAddOperation);
        PathAddress singletonPolicyPathAddress = subsystemPathAddress.append(SINGLETON_POLICY, "default");
        ModelNode singletonPolicyAddOperation = Util.createAddOperation((PathAddress)singletonPolicyPathAddress);
        singletonPolicyAddOperation.get(CACHE_CONTAINER_ATTR_NAME).set(CACHE_CONTAINER_ATTR_VALUE);
        compositeOperationBuilder.addStep(singletonPolicyAddOperation);
        PathAddress electionPolicyPathAddress = singletonPolicyPathAddress.append(ELECTION_POLICY, ELECTION_POLICY_NAME);
        ModelNode electionPolicyAddOperation = Util.createAddOperation((PathAddress)electionPolicyPathAddress);
        compositeOperationBuilder.addStep(electionPolicyAddOperation);
        serverConfiguration.executeManagementOperation(compositeOperationBuilder.build().getOperation());
    }
}

