/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.management.impl;

import java.nio.file.Path;
import java.util.ArrayList;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.migration.wfly10.WildFlyServer10;
import org.jboss.migration.wfly10.config.management.HostControllerConfiguration;
import org.jboss.migration.wfly10.config.management.impl.AbstractManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.impl.DeploymentOverlayResourceImpl;
import org.jboss.migration.wfly10.config.management.impl.DeploymentResourceImpl;
import org.jboss.migration.wfly10.config.management.impl.HostResourceImpl;
import org.jboss.migration.wfly10.config.management.impl.ProfileResourceImpl;
import org.jboss.migration.wfly10.config.management.impl.ServerGroupResourceImpl;
import org.jboss.migration.wfly10.config.task.ServerConfigurationMigration;
import org.wildfly.core.embedded.EmbeddedProcessFactory;
import org.wildfly.core.embedded.EmbeddedProcessStartException;
import org.wildfly.core.embedded.HostController;

public class EmbeddedHostControllerConfiguration
extends AbstractManageableServerConfiguration
implements HostControllerConfiguration {
    private final String domainConfig;
    private final String hostConfig;
    private HostController hostController;
    private final DeploymentResourceImpl.Factory deploymentResources;
    private final DeploymentOverlayResourceImpl.Factory deploymentOverlayResources;
    private final HostResourceImpl.Factory hostResources;
    private final ProfileResourceImpl.Factory profileResources;
    private final ServerGroupResourceImpl.Factory serverGroupResources;

    protected EmbeddedHostControllerConfiguration(String domainConfig, String hostConfig, WildFlyServer10 server) {
        super("", PathAddress.EMPTY_ADDRESS, server);
        this.domainConfig = domainConfig;
        this.hostConfig = hostConfig;
        this.deploymentResources = new DeploymentResourceImpl.Factory(this.getResourcePathAddress(), this);
        this.addChildResourceFactory(this.deploymentResources);
        this.deploymentOverlayResources = new DeploymentOverlayResourceImpl.Factory(this.getResourcePathAddress(), this);
        this.addChildResourceFactory(this.deploymentOverlayResources);
        this.hostResources = new HostResourceImpl.Factory(this.getResourcePathAddress(), this);
        this.addChildResourceFactory(this.hostResources);
        this.profileResources = new ProfileResourceImpl.Factory(this.getResourcePathAddress(), this);
        this.addChildResourceFactory(this.profileResources);
        this.serverGroupResources = new ServerGroupResourceImpl.Factory(this.getResourcePathAddress(), this);
        this.addChildResourceFactory(this.serverGroupResources);
    }

    @Override
    protected ModelControllerClient startConfiguration() {
        ArrayList<String> cmds = new ArrayList<String>();
        if (this.domainConfig != null) {
            cmds.add("--domain-config=" + this.domainConfig);
        }
        if (this.hostConfig != null) {
            cmds.add("--host-config=" + this.hostConfig);
        }
        cmds.add("--admin-only");
        String[] systemPackages = new String[]{"org.jboss.logmanager"};
        this.hostController = EmbeddedProcessFactory.createHostController((String)this.getServer().getBaseDir().toString(), null, (String[])systemPackages, (String[])cmds.toArray(new String[cmds.size()]));
        try {
            this.hostController.start();
        }
        catch (EmbeddedProcessStartException e) {
            throw new RuntimeException(e);
        }
        return this.hostController.getModelControllerClient();
    }

    @Override
    protected void stopConfiguration() {
        if (this.hostConfig == null) {
            this.writeConfiguration();
        }
        this.hostController.stop();
        this.hostController = null;
    }

    public static class HostConfigFileMigrationFactory
    implements ServerConfigurationMigration.ManageableConfigurationProvider {
        public HostControllerConfiguration getManageableConfiguration(Path configFile, WildFlyServer10 server) {
            return new EmbeddedHostControllerConfiguration(null, configFile.getFileName().toString(), server);
        }
    }

    public static class DomainConfigFileMigrationFactory
    implements ServerConfigurationMigration.ManageableConfigurationProvider {
        public HostControllerConfiguration getManageableConfiguration(Path configFile, WildFlyServer10 server) {
            return new EmbeddedHostControllerConfiguration(configFile.getFileName().toString(), null, server);
        }
    }
}

