/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.update;

import org.jboss.migration.core.JBossServer;
import org.jboss.migration.core.ServerPath;
import org.jboss.migration.wfly10.config.management.HostConfiguration;
import org.jboss.migration.wfly10.config.management.HostControllerConfiguration;
import org.jboss.migration.wfly10.config.management.StandaloneServerConfiguration;
import org.jboss.migration.wfly10.config.task.DomainConfigurationMigration;
import org.jboss.migration.wfly10.config.task.DomainMigration;
import org.jboss.migration.wfly10.config.task.HostConfigurationMigration;
import org.jboss.migration.wfly10.config.task.MigrationBuilders;
import org.jboss.migration.wfly10.config.task.ServerConfigurationMigration;
import org.jboss.migration.wfly10.config.task.ServerMigration;
import org.jboss.migration.wfly10.config.task.StandaloneServerConfigurationMigration;
import org.jboss.migration.wfly10.config.task.StandaloneServerMigration;
import org.jboss.migration.wfly10.config.task.factory.DomainConfigurationTaskFactory;
import org.jboss.migration.wfly10.config.task.factory.HostConfigurationTaskFactory;
import org.jboss.migration.wfly10.config.task.factory.ManageableServerConfigurationTaskFactory;
import org.jboss.migration.wfly10.config.task.factory.StandaloneServerConfigurationTaskFactory;
import org.jboss.migration.wfly10.config.task.update.CopySourceXMLConfiguration;
import org.jboss.migration.wfly10.config.task.update.DomainUpdate;
import org.jboss.migration.wfly10.config.task.update.HostUpdate;
import org.jboss.migration.wfly10.config.task.update.StandaloneServerConfigurationsUpdate;

public class ServerUpdate<S extends JBossServer<S>>
extends ServerMigration<S> {
    public ServerUpdate(ServerMigration.Builder<S> builder) {
        super(builder);
    }

    public static class SimpleBuilder<S extends JBossServer<S>> {
        private final Builders<S> builders = new Builders();
        private StandaloneServerConfigurationMigration.Builder<ServerPath<S>> standaloneBuilder;
        private DomainConfigurationMigration.Builder<ServerPath<S>> domainBuilder;
        private HostUpdate.Builder<S> hostBuilder;

        public synchronized StandaloneServerConfigurationMigration.Builder<ServerPath<S>> standaloneConfigBuilder() {
            if (this.standaloneBuilder == null) {
                this.standaloneBuilder = this.builders.standaloneConfigurationBuilder();
            }
            return this.standaloneBuilder;
        }

        public synchronized DomainConfigurationMigration.Builder<ServerPath<S>> domainConfigBuilder() {
            if (this.domainBuilder == null) {
                this.domainBuilder = this.builders.domainConfigurationBuilder();
            }
            return this.domainBuilder;
        }

        public synchronized HostUpdate.Builder<S> hostConfigBuilder() {
            if (this.hostBuilder == null) {
                this.hostBuilder = this.builders.hostBuilder();
            }
            return this.hostBuilder;
        }

        public SimpleBuilder<S> standaloneConfigTask(ServerConfigurationMigration.XMLConfigurationSubtaskFactory<ServerPath<S>> subtaskFactory) {
            this.standaloneConfigBuilder().subtask((ServerConfigurationMigration.XMLConfigurationSubtaskFactory)subtaskFactory);
            return this;
        }

        public SimpleBuilder<S> standaloneConfigTask(ManageableServerConfigurationTaskFactory<ServerPath<S>, StandaloneServerConfiguration> subtaskFactory) {
            this.standaloneConfigBuilder().subtask((ManageableServerConfigurationTaskFactory)subtaskFactory);
            return this;
        }

        public SimpleBuilder<S> standaloneConfigTask(StandaloneServerConfigurationTaskFactory<ServerPath<S>> subtaskFactory) {
            this.standaloneConfigBuilder().subtask(subtaskFactory);
            return this;
        }

        public SimpleBuilder<S> domainConfigTask(ServerConfigurationMigration.XMLConfigurationSubtaskFactory<ServerPath<S>> subtaskFactory) {
            this.domainConfigBuilder().subtask((ServerConfigurationMigration.XMLConfigurationSubtaskFactory)subtaskFactory);
            return this;
        }

        public SimpleBuilder<S> domainConfigTask(ManageableServerConfigurationTaskFactory<ServerPath<S>, HostControllerConfiguration> subtaskFactory) {
            this.domainConfigBuilder().subtask((ManageableServerConfigurationTaskFactory)subtaskFactory);
            return this;
        }

        public SimpleBuilder<S> domainConfigTask(DomainConfigurationTaskFactory<ServerPath<S>> subtaskFactory) {
            this.domainConfigBuilder().subtask(subtaskFactory);
            return this;
        }

        public SimpleBuilder<S> hostConfigTask(ManageableServerConfigurationTaskFactory<ServerPath<S>, HostConfiguration> subtaskFactory) {
            this.hostConfigBuilder().subtask((ManageableServerConfigurationTaskFactory)subtaskFactory);
            return this;
        }

        public SimpleBuilder<S> hostConfigTask(HostConfigurationTaskFactory<ServerPath<S>> subtaskFactory) {
            this.hostConfigBuilder().subtask((HostConfigurationTaskFactory)subtaskFactory);
            return this;
        }

        public ServerUpdate<S> build() {
            Builder<S> builder = new Builder<S>();
            if (this.standaloneBuilder != null) {
                builder.standaloneServer(this.standaloneBuilder);
            }
            if (this.domainBuilder != null || this.hostBuilder != null) {
                DomainMigration.Builder domain = this.builders.domainBuilder();
                if (this.domainBuilder != null) {
                    ((DomainUpdate.Builder)domain).domainConfigurations(this.domainBuilder);
                }
                if (this.hostBuilder != null) {
                    ((DomainUpdate.Builder)domain).hostConfigurations(this.builders.hostConfigurationBuilder().subtask(this.hostBuilder));
                }
                builder.domain(domain);
            }
            return builder.build();
        }
    }

    public static class Builders<S extends JBossServer<S>>
    extends MigrationBuilders<S, ServerPath<S>> {
        private final ServerConfigurationMigration.XMLConfigurationProvider<S> defaultXmlConfigurationProvider = new CopySourceXMLConfiguration();

        public Builder<S> serverUpdateBuilder() {
            return new Builder();
        }

        public DomainConfigurationMigration.Builder<ServerPath<S>> domainConfigurationBuilder() {
            return new DomainConfigurationMigration.Builder<ServerPath<S>>(this.defaultXmlConfigurationProvider);
        }

        public HostConfigurationMigration.Builder<ServerPath<S>> hostConfigurationBuilder() {
            return new HostConfigurationMigration.Builder<ServerPath<S>>(this.defaultXmlConfigurationProvider);
        }

        public StandaloneServerConfigurationMigration.Builder<ServerPath<S>> standaloneConfigurationBuilder() {
            return new StandaloneServerConfigurationMigration.Builder<ServerPath<S>>(this.defaultXmlConfigurationProvider);
        }

        @Override
        public DomainUpdate.Builder<S> domainBuilder() {
            return new DomainUpdate.Builder();
        }

        @Override
        public HostUpdate.Builder<S> hostBuilder() {
            return new HostUpdate.Builder();
        }
    }

    public static class Builder<S extends JBossServer<S>>
    extends ServerMigration.Builder<S> {
        @Override
        public Builder<S> subtask(ServerMigration.SubtaskFactory<S> subtaskFactory) {
            super.subtask(subtaskFactory);
            return this;
        }

        public Builder<S> domain(DomainMigration<S> domainUpdate) {
            return this.subtask((ServerMigration.SubtaskFactory)domainUpdate);
        }

        public Builder<S> domain(DomainMigration.Builder<S> domainUpdateBuilder) {
            return this.domain(domainUpdateBuilder.build());
        }

        public Builder<S> standaloneServer(StandaloneServerMigration<S> standaloneServerUpdate) {
            return this.subtask((ServerMigration.SubtaskFactory)standaloneServerUpdate);
        }

        public Builder<S> standaloneServer(StandaloneServerConfigurationsUpdate<S> configurationsMigration) {
            return this.standaloneServer(new StandaloneServerMigration(configurationsMigration));
        }

        public Builder<S> standaloneServer(StandaloneServerConfigurationMigration<ServerPath<S>> standaloneServerConfigurationUpdate) {
            return this.standaloneServer(new StandaloneServerConfigurationsUpdate<S>(standaloneServerConfigurationUpdate));
        }

        public Builder<S> standaloneServer(StandaloneServerConfigurationMigration.Builder<ServerPath<S>> standaloneServerConfigurationUpdateBuilder) {
            return this.standaloneServer((StandaloneServerConfigurationMigration<ServerPath<S>>)standaloneServerConfigurationUpdateBuilder.build());
        }

        @Override
        public ServerUpdate<S> build() {
            return new ServerUpdate(this);
        }
    }
}

