/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.update;

import org.jboss.migration.core.ParentServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.core.ServerMigrationTaskName;
import org.jboss.migration.core.ServerMigrationTaskResult;
import org.jboss.migration.core.env.SkippableByEnvServerMigrationTask;
import org.jboss.migration.wfly10.config.management.DeploymentsManagement;
import org.jboss.migration.wfly10.config.management.HostControllerConfiguration;
import org.jboss.migration.wfly10.config.management.StandaloneServerConfiguration;
import org.jboss.migration.wfly10.config.task.executor.DeploymentsManagementSubtaskExecutor;
import org.jboss.migration.wfly10.config.task.executor.SubtaskExecutorAdapters;
import org.jboss.migration.wfly10.config.task.factory.DomainConfigurationTaskFactory;
import org.jboss.migration.wfly10.config.task.factory.StandaloneServerConfigurationTaskFactory;

public class RemoveDeployments<S>
implements StandaloneServerConfigurationTaskFactory<S>,
DomainConfigurationTaskFactory<S> {
    public static final RemoveDeployments INSTANCE = new RemoveDeployments();
    private static final String TASK_NAME_NAME = "remove-deployments";
    private static final ServerMigrationTaskName TASK_NAME = new ServerMigrationTaskName.Builder("remove-deployments").build();

    private RemoveDeployments() {
    }

    @Override
    public ServerMigrationTask getTask(S source, StandaloneServerConfiguration configuration) throws Exception {
        return this.getTask(source, configuration.getDeploymentsManagement());
    }

    @Override
    public ServerMigrationTask getTask(S source, HostControllerConfiguration configuration) throws Exception {
        return this.getTask(source, configuration.getDeploymentsManagement());
    }

    protected ServerMigrationTask getTask(S source, DeploymentsManagement deploymentsManagement) throws Exception {
        ParentServerMigrationTask parentTask = new ParentServerMigrationTask.Builder(TASK_NAME).subtask(SubtaskExecutorAdapters.of(source, deploymentsManagement, new SubtaskExecutor())).build();
        return new SkippableByEnvServerMigrationTask((ServerMigrationTask)parentTask, TASK_NAME + ".skip");
    }

    public static class SubtaskExecutor<S>
    implements DeploymentsManagementSubtaskExecutor<S> {
        private static final String SUBTASK_NAME_NAME = "remove-deployment";

        @Override
        public void executeSubtasks(S source, final DeploymentsManagement deploymentsManagement, ServerMigrationTaskContext context) throws Exception {
            for (final String resourceName : deploymentsManagement.getResourceNames()) {
                final ServerMigrationTaskName taskName = new ServerMigrationTaskName.Builder(SUBTASK_NAME_NAME).addAttribute("name", resourceName).build();
                ServerMigrationTask subtask = new ServerMigrationTask(){

                    public ServerMigrationTaskName getName() {
                        return taskName;
                    }

                    public ServerMigrationTaskResult run(ServerMigrationTaskContext context) throws Exception {
                        deploymentsManagement.removeResource(resourceName);
                        context.getLogger().infof("Removed deployment %s", (Object)resourceName);
                        return ServerMigrationTaskResult.SUCCESS;
                    }
                };
                context.execute(subtask);
            }
        }
    }
}

