/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.update;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.JBossServer;
import org.jboss.migration.core.ParentServerMigrationTask;
import org.jboss.migration.core.Server;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.core.ServerMigrationTaskName;
import org.jboss.migration.core.ServerMigrationTaskResult;
import org.jboss.migration.core.ServerPath;
import org.jboss.migration.core.env.SkippableByEnvServerMigrationTask;
import org.jboss.migration.wfly10.WildFly10Server;
import org.jboss.migration.wfly10.config.management.HostConfiguration;
import org.jboss.migration.wfly10.config.management.SecurityRealmsManagement;
import org.jboss.migration.wfly10.config.management.StandaloneServerConfiguration;
import org.jboss.migration.wfly10.config.task.executor.SecurityRealmsManagementSubtaskExecutor;
import org.jboss.migration.wfly10.config.task.executor.SubtaskExecutorAdapters;
import org.jboss.migration.wfly10.config.task.factory.HostConfigurationTaskFactory;
import org.jboss.migration.wfly10.config.task.factory.StandaloneServerConfigurationTaskFactory;

public class MigrateCompatibleSecurityRealms<S extends JBossServer<S>>
implements StandaloneServerConfigurationTaskFactory<ServerPath<S>>,
HostConfigurationTaskFactory<ServerPath<S>> {
    public static final MigrateCompatibleSecurityRealms INSTANCE = new MigrateCompatibleSecurityRealms();
    private static final String TASK_NAME_NAME = "migrate-compatible-security-realms";
    private static final ServerMigrationTaskName TASK_NAME = new ServerMigrationTaskName.Builder("migrate-compatible-security-realms").build();
    private static final String SUBTASK_NAME_NAME = "migrate-compatible-security-realm";
    public static final String SECURITY_REALM = "security-realm";

    private MigrateCompatibleSecurityRealms() {
    }

    @Override
    public ServerMigrationTask getTask(ServerPath<S> source, StandaloneServerConfiguration configuration) throws Exception {
        return this.getTask(source, configuration.getSecurityRealmsManagement());
    }

    @Override
    public ServerMigrationTask getTask(ServerPath<S> source, HostConfiguration configuration) throws Exception {
        return this.getTask(source, configuration.getSecurityRealmsManagement());
    }

    public ServerMigrationTask getTask(ServerPath<S> source, SecurityRealmsManagement resourcesManagement) throws Exception {
        ParentServerMigrationTask.Builder taskBuilder = new ParentServerMigrationTask.Builder(TASK_NAME).subtask(SubtaskExecutorAdapters.of(source, resourcesManagement, new SubtaskExecutor())).eventListener(new ParentServerMigrationTask.EventListener(){

            public void started(ServerMigrationTaskContext context) {
                context.getLogger().infof("Migrating security realms...", new Object[0]);
            }

            public void done(ServerMigrationTaskContext context) {
                context.getLogger().infof("Security realms migration done.", new Object[0]);
            }
        });
        return new SkippableByEnvServerMigrationTask((ServerMigrationTask)taskBuilder.build(), TASK_NAME + ".skip");
    }

    protected static class Task<S extends Server>
    implements ServerMigrationTask {
        private final ServerMigrationTaskName name;
        private final ServerPath<S> source;
        private final String securityRealmName;
        private final SecurityRealmsManagement securityRealmsManagement;

        protected Task(ServerMigrationTaskName name, ServerPath<S> source, String securityRealmName, SecurityRealmsManagement securityRealmsManagement) {
            this.name = name;
            this.source = source;
            this.securityRealmName = securityRealmName;
            this.securityRealmsManagement = securityRealmsManagement;
        }

        public ServerMigrationTaskName getName() {
            return this.name;
        }

        public ServerMigrationTaskResult run(ServerMigrationTaskContext context) throws Exception {
            context.getLogger().debugf("Security realm %s migration starting...", (Object)this.securityRealmName);
            ModelNode securityRealmConfig = this.securityRealmsManagement.getResource(this.securityRealmName);
            if (securityRealmConfig.hasDefined(new String[]{"authentication", "properties"})) {
                this.copyPropertiesFile("authentication", this.securityRealmName, securityRealmConfig, this.source, this.securityRealmsManagement, context);
            }
            if (securityRealmConfig.hasDefined(new String[]{"authorization", "properties"})) {
                this.copyPropertiesFile("authorization", this.securityRealmName, securityRealmConfig, this.source, this.securityRealmsManagement, context);
            }
            context.getLogger().infof("Security realm %s migrated.", (Object)this.securityRealmName);
            return ServerMigrationTaskResult.SUCCESS;
        }

        private void copyPropertiesFile(String propertiesName, String securityRealmName, ModelNode securityRealmConfig, ServerPath<S> source, SecurityRealmsManagement securityRealmsManagement, ServerMigrationTaskContext context) throws IOException {
            Server sourceServer = source.getServer();
            WildFly10Server targetServer = securityRealmsManagement.getServerConfiguration().getServer();
            ModelNode properties = securityRealmConfig.get(propertiesName);
            if (properties.hasDefined("path")) {
                String path = properties.get("path").asString();
                context.getLogger().debugf("Properties path: %s", (Object)path);
                String relativeTo = null;
                if (properties.hasDefined("relative-to")) {
                    relativeTo = properties.get("relative-to").asString();
                }
                context.getLogger().debugf("Properties relative_to: %s", (Object)String.valueOf(relativeTo));
                if (relativeTo == null) {
                    Path sourcePath = Paths.get(path, new String[0]);
                    context.getLogger().infof("Source Properties file path: %s", (Object)sourcePath);
                    if (sourcePath.startsWith(sourceServer.getBaseDir())) {
                        Path targetPath = sourceServer.getBaseDir().resolve(targetServer.getBaseDir().relativize(sourcePath));
                        context.getLogger().infof("Target Properties file path: %s", (Object)targetPath);
                        context.getServerMigrationContext().getMigrationFiles().copy(sourcePath, targetPath);
                        PathAddress pathAddress = securityRealmsManagement.getResourcePathAddress(securityRealmName).append(new PathElement[]{PathElement.pathElement((String)propertiesName, (String)"properties")});
                        ModelNode op = Util.createEmptyOperation((String)"write-attribute", (PathAddress)pathAddress);
                        op.get("name").set("path");
                        op.get("value").set(targetPath.toString());
                        securityRealmsManagement.getServerConfiguration().executeManagementOperation(op);
                    } else {
                        context.getLogger().infof("Source Properties file path is not in source server base dir, skipping file copy", new Object[0]);
                    }
                } else {
                    Path resolvedSourcePath = sourceServer.resolvePath(relativeTo);
                    if (resolvedSourcePath == null) {
                        throw new IOException("failed to resolve source path " + relativeTo);
                    }
                    Path sourcePath = resolvedSourcePath.normalize().resolve(path);
                    context.getLogger().infof("Source Properties file path: %s", (Object)sourcePath);
                    Path resolvedTargetPath = targetServer.resolvePath(relativeTo);
                    if (resolvedTargetPath == null) {
                        throw new IOException("failed to resolve target path " + relativeTo);
                    }
                    Path targetPath = resolvedTargetPath.normalize().resolve(path);
                    context.getLogger().infof("Target Properties file path: %s", (Object)targetPath);
                    if (!sourcePath.equals(targetPath)) {
                        context.getServerMigrationContext().getMigrationFiles().copy(sourcePath, targetPath);
                    } else {
                        context.getLogger().infof("Resolved paths for Source and Target Properties files is the same.", new Object[0]);
                    }
                }
            }
        }
    }

    public static class SubtaskExecutor<S extends JBossServer<S>>
    implements SecurityRealmsManagementSubtaskExecutor<ServerPath<S>> {
        @Override
        public void executeSubtasks(ServerPath<S> source, SecurityRealmsManagement resourceManagement, ServerMigrationTaskContext context) throws Exception {
            for (String resourceName : resourceManagement.getResourceNames()) {
                ServerMigrationTaskName taskName = new ServerMigrationTaskName.Builder(MigrateCompatibleSecurityRealms.SUBTASK_NAME_NAME).addAttribute("name", resourceName).build();
                context.execute(new Task<S>(taskName, source, resourceName, resourceManagement));
            }
        }
    }
}

