/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem.undertow;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.core.ServerMigrationTaskName;
import org.jboss.migration.core.ServerMigrationTaskResult;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.wfly10.config.management.SubsystemsManagement;
import org.jboss.migration.wfly10.config.task.subsystem.UpdateSubsystemTaskFactory;

public class MigrateHttpListener
implements UpdateSubsystemTaskFactory.SubtaskFactory {
    private static final String SERVER = "server";
    private static final String SERVER_NAME = "default-server";
    private static final String HTTP_LISTENER = "http-listener";
    private static final String HTTP_LISTENER_NAME = "http";
    private static final String REDIRECT_SOCKET_ATTR_NAME = "redirect-socket";
    private static final String REDIRECT_SOCKET_ATTR_VALUE = "https";
    public static final ServerMigrationTaskName SERVER_MIGRATION_TASK_NAME = new ServerMigrationTaskName.Builder("migrate-undertow-http-listener").build();
    public static final MigrateHttpListener INSTANCE = new MigrateHttpListener();

    private MigrateHttpListener() {
    }

    @Override
    public ServerMigrationTask getServerMigrationTask(ModelNode config, UpdateSubsystemTaskFactory subsystem, SubsystemsManagement subsystemsManagement) {
        return new UpdateSubsystemTaskFactory.Subtask(config, subsystem, subsystemsManagement){

            public ServerMigrationTaskName getName() {
                return SERVER_MIGRATION_TASK_NAME;
            }

            @Override
            protected ServerMigrationTaskResult run(ModelNode config, UpdateSubsystemTaskFactory subsystem, SubsystemsManagement subsystemsManagement, ServerMigrationTaskContext context, TaskEnvironment taskEnvironment) throws Exception {
                if (config == null) {
                    return ServerMigrationTaskResult.SKIPPED;
                }
                if (config.hasDefined(new String[]{MigrateHttpListener.SERVER, MigrateHttpListener.SERVER_NAME, MigrateHttpListener.HTTP_LISTENER, MigrateHttpListener.HTTP_LISTENER_NAME})) {
                    PathAddress pathAddress = subsystemsManagement.getResourcePathAddress(subsystem.getName()).append(new PathElement[]{PathElement.pathElement((String)MigrateHttpListener.SERVER, (String)MigrateHttpListener.SERVER_NAME), PathElement.pathElement((String)MigrateHttpListener.HTTP_LISTENER, (String)MigrateHttpListener.HTTP_LISTENER_NAME)});
                    ModelNode op = Util.createEmptyOperation((String)"write-attribute", (PathAddress)pathAddress);
                    op.get("name").set(MigrateHttpListener.REDIRECT_SOCKET_ATTR_NAME);
                    op.get("value").set(MigrateHttpListener.REDIRECT_SOCKET_ATTR_VALUE);
                    subsystemsManagement.getServerConfiguration().executeManagementOperation(op);
                    context.getLogger().infof("Undertow's default HTTP listener 'redirect-socket' set to 'https'.", new Object[0]);
                    return ServerMigrationTaskResult.SUCCESS;
                }
                return ServerMigrationTaskResult.SKIPPED;
            }
        };
    }
}

