/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem.singleton;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.SubsystemsManagement;
import org.jboss.migration.wfly10.config.task.subsystem.AddSubsystemConfigSubtask;

public class AddSingletonSubsystem<S>
extends AddSubsystemConfigSubtask<S> {
    public static final AddSingletonSubsystem INSTANCE = new AddSingletonSubsystem();
    private static final String DEFAULT_ATTR_NAME = "default";
    private static final String DEFAULT_ATTR_VALUE = "default";
    private static final String SINGLETON_POLICY = "singleton-policy";
    private static final String CACHE_CONTAINER_ATTR_NAME = "cache-container";
    private static final String CACHE_CONTAINER_ATTR_VALUE = "server";
    private static final String ELECTION_POLICY = "election-policy";
    private static final String ELECTION_POLICY_NAME = "simple";

    private AddSingletonSubsystem() {
        super("singleton");
    }

    @Override
    protected void addSubsystem(SubsystemsManagement subsystemsManagement, ServerMigrationTaskContext context) throws Exception {
        ManageableServerConfiguration configurationManagement = subsystemsManagement.getServerConfiguration();
        Operations.CompositeOperationBuilder compositeOperationBuilder = Operations.CompositeOperationBuilder.create();
        PathAddress subsystemPathAddress = subsystemsManagement.getResourcePathAddress(this.subsystemName);
        ModelNode subsystemAddOperation = Util.createAddOperation((PathAddress)subsystemPathAddress);
        subsystemAddOperation.get("default").set("default");
        compositeOperationBuilder.addStep(subsystemAddOperation);
        PathAddress singletonPolicyPathAddress = subsystemPathAddress.append(SINGLETON_POLICY, "default");
        ModelNode singletonPolicyAddOperation = Util.createAddOperation((PathAddress)singletonPolicyPathAddress);
        singletonPolicyAddOperation.get(CACHE_CONTAINER_ATTR_NAME).set(CACHE_CONTAINER_ATTR_VALUE);
        compositeOperationBuilder.addStep(singletonPolicyAddOperation);
        PathAddress electionPolicyPathAddress = singletonPolicyPathAddress.append(ELECTION_POLICY, ELECTION_POLICY_NAME);
        ModelNode electionPolicyAddOperation = Util.createAddOperation((PathAddress)electionPolicyPathAddress);
        compositeOperationBuilder.addStep(electionPolicyAddOperation);
        configurationManagement.executeManagementOperation(compositeOperationBuilder.build().getOperation());
    }
}

