/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem.remoting;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.core.ServerMigrationTaskName;
import org.jboss.migration.core.ServerMigrationTaskResult;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.SubsystemsManagement;
import org.jboss.migration.wfly10.config.task.subsystem.UpdateSubsystemTaskFactory;

public class AddHttpConnectorIfMissing
implements UpdateSubsystemTaskFactory.SubtaskFactory {
    public static final String DEFAULT_HTTP_CONNECTOR_NAME = "http-remoting-connector";
    public static final String DEFAULT_CONNECTOR_REF_NAME = "http";
    public static final String DEFAULT_SECURITY_REALM_NAME = "ApplicationRealm";
    public static final AddHttpConnectorIfMissing INSTANCE = new AddHttpConnectorIfMissing();
    public static final ServerMigrationTaskName SERVER_MIGRATION_TASK_NAME = new ServerMigrationTaskName.Builder("add-remoting-http-connector").build();
    private static final String HTTP_CONNECTOR = "http-connector";
    private static final String CONNECTOR_REF = "connector-ref";
    private static final String SECURITY_REALM = "security-realm";

    private AddHttpConnectorIfMissing() {
    }

    @Override
    public ServerMigrationTask getServerMigrationTask(ModelNode config, UpdateSubsystemTaskFactory subsystem, SubsystemsManagement subsystemsManagement) {
        return new UpdateSubsystemTaskFactory.Subtask(config, subsystem, subsystemsManagement){

            public ServerMigrationTaskName getName() {
                return SERVER_MIGRATION_TASK_NAME;
            }

            @Override
            protected ServerMigrationTaskResult run(ModelNode config, UpdateSubsystemTaskFactory subsystem, SubsystemsManagement subsystemsManagement, ServerMigrationTaskContext context, TaskEnvironment taskEnvironment) throws Exception {
                if (config == null) {
                    return ServerMigrationTaskResult.SKIPPED;
                }
                PathAddress subsystemPathAddress = subsystemsManagement.getResourcePathAddress(subsystem.getName());
                ManageableServerConfiguration configurationManagement = subsystemsManagement.getServerConfiguration();
                String httpConnectorName = taskEnvironment.getPropertyAsString("httpConnectorName", AddHttpConnectorIfMissing.DEFAULT_HTTP_CONNECTOR_NAME);
                String connectorRefName = taskEnvironment.getPropertyAsString("connectorRefName", AddHttpConnectorIfMissing.DEFAULT_CONNECTOR_REF_NAME);
                String securityRealmName = taskEnvironment.getPropertyAsString("securityRealmName", AddHttpConnectorIfMissing.DEFAULT_SECURITY_REALM_NAME);
                if (!config.hasDefined(new String[]{AddHttpConnectorIfMissing.HTTP_CONNECTOR, httpConnectorName})) {
                    PathAddress httpRemotingConnectorPathAddress = subsystemPathAddress.append(new PathElement[]{PathElement.pathElement((String)AddHttpConnectorIfMissing.HTTP_CONNECTOR, (String)httpConnectorName)});
                    ModelNode httpRemotingConnectorAddOp = Util.createEmptyOperation((String)"add", (PathAddress)httpRemotingConnectorPathAddress);
                    httpRemotingConnectorAddOp.get(AddHttpConnectorIfMissing.CONNECTOR_REF).set(connectorRefName);
                    httpRemotingConnectorAddOp.get(AddHttpConnectorIfMissing.SECURITY_REALM).set(securityRealmName);
                    configurationManagement.executeManagementOperation(httpRemotingConnectorAddOp);
                    context.getLogger().infof("Http connector %s added to Remoting subsystem configuration.", (Object)httpConnectorName);
                    return ServerMigrationTaskResult.SUCCESS;
                }
                return ServerMigrationTaskResult.SKIPPED;
            }
        };
    }

    public static interface EnvironmentProperties {
        public static final String HTTP_CONNECTOR_NAME = "httpConnectorName";
        public static final String CONNECTOR_REF_NAME = "connectorRefName";
        public static final String SECURITY_REALM_NAME = "securityRealmName";
    }
}

