/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem.ee;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.core.ServerMigrationTaskName;
import org.jboss.migration.core.ServerMigrationTaskResult;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.SubsystemsManagement;
import org.jboss.migration.wfly10.config.task.subsystem.UpdateSubsystemTaskFactory;

public class AddConcurrencyUtilitiesDefaultConfig
implements UpdateSubsystemTaskFactory.SubtaskFactory {
    public static final String DEFAULT_CONTEXT_SERVICE_JNDI_NAME = "java:jboss/ee/concurrency/context/default";
    public static final String DEFAULT_MANAGED_THREAD_FACTORY_JNDI_NAME = "java:jboss/ee/concurrency/factory/default";
    public static final String DEFAULT_MANAGED_EXECUTOR_SERVICE_JNDI_NAME = "java:jboss/ee/concurrency/executor/default";
    public static final String DEFAULT_MANAGED_SCHEDULED_EXECUTOR_SERVICE_JNDI_NAME = "java:jboss/ee/concurrency/scheduler/default";
    public static final String TASK_RESULT_ATTR_CONTEXT_SERVICE = "context-service";
    public static final String TASK_RESULT_ATTR_MANAGED_THREAD_FACTORY = "managed-thread-factory";
    public static final String TASK_RESULT_ATTR_MANAGED_EXECUTOR_SERVICE = "managed-executor-service";
    public static final String TASK_RESULT_ATTR_MANAGED_SCHEDULED_EXECUTOR_SERVICE = "managed-scheduled-executor-service";
    public static final AddConcurrencyUtilitiesDefaultConfig INSTANCE = new AddConcurrencyUtilitiesDefaultConfig();
    public static final ServerMigrationTaskName SERVER_MIGRATION_TASK_NAME = new ServerMigrationTaskName.Builder("setup-ee-concurrency-utilities").build();

    private AddConcurrencyUtilitiesDefaultConfig() {
    }

    @Override
    public ServerMigrationTask getServerMigrationTask(ModelNode config, UpdateSubsystemTaskFactory subsystem, SubsystemsManagement subsystemsManagement) {
        return new UpdateSubsystemTaskFactory.Subtask(config, subsystem, subsystemsManagement){

            public ServerMigrationTaskName getName() {
                return SERVER_MIGRATION_TASK_NAME;
            }

            @Override
            protected ServerMigrationTaskResult run(ModelNode config, UpdateSubsystemTaskFactory subsystem, SubsystemsManagement subsystemsManagement, ServerMigrationTaskContext context, TaskEnvironment taskEnvironment) throws Exception {
                if (config == null) {
                    return ServerMigrationTaskResult.SKIPPED;
                }
                ServerMigrationTaskResult.Builder taskResultBuilder = new ServerMigrationTaskResult.Builder();
                PathAddress subsystemPathAddress = subsystemsManagement.getResourcePathAddress(subsystem.getName());
                ManageableServerConfiguration configurationManagement = subsystemsManagement.getServerConfiguration();
                PathAddress defaultContextServicePathAddress = subsystemPathAddress.append(new PathElement[]{PathElement.pathElement((String)AddConcurrencyUtilitiesDefaultConfig.TASK_RESULT_ATTR_CONTEXT_SERVICE, (String)"default")});
                ModelNode defaultContextServiceAddOp = Util.createEmptyOperation((String)"add", (PathAddress)defaultContextServicePathAddress);
                defaultContextServiceAddOp.get("jndi-name").set(AddConcurrencyUtilitiesDefaultConfig.DEFAULT_CONTEXT_SERVICE_JNDI_NAME);
                defaultContextServiceAddOp.get("use-transaction-setup-provider").set(true);
                configurationManagement.executeManagementOperation(defaultContextServiceAddOp);
                context.getLogger().infof("Default ContextService added to EE subsystem configuration.", new Object[0]);
                taskResultBuilder.addAttribute(AddConcurrencyUtilitiesDefaultConfig.TASK_RESULT_ATTR_CONTEXT_SERVICE, (Object)AddConcurrencyUtilitiesDefaultConfig.DEFAULT_CONTEXT_SERVICE_JNDI_NAME);
                PathAddress defaultManagedThreadFactoryPathAddress = subsystemPathAddress.append(new PathElement[]{PathElement.pathElement((String)AddConcurrencyUtilitiesDefaultConfig.TASK_RESULT_ATTR_MANAGED_THREAD_FACTORY, (String)"default")});
                ModelNode defaultManagedThreadFactoryAddOp = Util.createEmptyOperation((String)"add", (PathAddress)defaultManagedThreadFactoryPathAddress);
                defaultManagedThreadFactoryAddOp.get("jndi-name").set(AddConcurrencyUtilitiesDefaultConfig.DEFAULT_MANAGED_THREAD_FACTORY_JNDI_NAME);
                defaultManagedThreadFactoryAddOp.get(AddConcurrencyUtilitiesDefaultConfig.TASK_RESULT_ATTR_CONTEXT_SERVICE).set("default");
                defaultManagedThreadFactoryAddOp.get("priority").set(5);
                configurationManagement.executeManagementOperation(defaultManagedThreadFactoryAddOp);
                context.getLogger().infof("Default ManagedThreadFactory added to EE subsystem configuration.", new Object[0]);
                taskResultBuilder.addAttribute(AddConcurrencyUtilitiesDefaultConfig.TASK_RESULT_ATTR_MANAGED_THREAD_FACTORY, (Object)AddConcurrencyUtilitiesDefaultConfig.DEFAULT_MANAGED_THREAD_FACTORY_JNDI_NAME);
                PathAddress defaultManagedExecutorServicePathAddress = subsystemPathAddress.append(new PathElement[]{PathElement.pathElement((String)AddConcurrencyUtilitiesDefaultConfig.TASK_RESULT_ATTR_MANAGED_EXECUTOR_SERVICE, (String)"default")});
                ModelNode defaultManagedExecutorServiceAddOp = Util.createEmptyOperation((String)"add", (PathAddress)defaultManagedExecutorServicePathAddress);
                defaultManagedExecutorServiceAddOp.get("jndi-name").set(AddConcurrencyUtilitiesDefaultConfig.DEFAULT_MANAGED_EXECUTOR_SERVICE_JNDI_NAME);
                defaultManagedExecutorServiceAddOp.get(AddConcurrencyUtilitiesDefaultConfig.TASK_RESULT_ATTR_CONTEXT_SERVICE).set("default");
                defaultManagedExecutorServiceAddOp.get("hung-task-threshold").set(60000L);
                defaultManagedExecutorServiceAddOp.get("keepalive-time").set(5000L);
                defaultManagedExecutorServiceAddOp.get("long-running-tasks").set(false);
                defaultManagedExecutorServiceAddOp.get("reject-policy").set("ABORT");
                configurationManagement.executeManagementOperation(defaultManagedExecutorServiceAddOp);
                context.getLogger().infof("Default ManagedExecutorService added to EE subsystem configuration.", new Object[0]);
                taskResultBuilder.addAttribute(AddConcurrencyUtilitiesDefaultConfig.TASK_RESULT_ATTR_MANAGED_EXECUTOR_SERVICE, (Object)AddConcurrencyUtilitiesDefaultConfig.DEFAULT_MANAGED_EXECUTOR_SERVICE_JNDI_NAME);
                PathAddress defaultManagedScheduledExecutorServicePathAddress = subsystemPathAddress.append(new PathElement[]{PathElement.pathElement((String)AddConcurrencyUtilitiesDefaultConfig.TASK_RESULT_ATTR_MANAGED_SCHEDULED_EXECUTOR_SERVICE, (String)"default")});
                ModelNode defaultManagedScheduledExecutorServiceAddOp = Util.createEmptyOperation((String)"add", (PathAddress)defaultManagedScheduledExecutorServicePathAddress);
                defaultManagedScheduledExecutorServiceAddOp.get("jndi-name").set(AddConcurrencyUtilitiesDefaultConfig.DEFAULT_MANAGED_SCHEDULED_EXECUTOR_SERVICE_JNDI_NAME);
                defaultManagedScheduledExecutorServiceAddOp.get(AddConcurrencyUtilitiesDefaultConfig.TASK_RESULT_ATTR_CONTEXT_SERVICE).set("default");
                defaultManagedScheduledExecutorServiceAddOp.get("hung-task-threshold").set(60000L);
                defaultManagedScheduledExecutorServiceAddOp.get("keepalive-time").set(3000L);
                defaultManagedScheduledExecutorServiceAddOp.get("long-running-tasks").set(false);
                defaultManagedScheduledExecutorServiceAddOp.get("reject-policy").set("ABORT");
                configurationManagement.executeManagementOperation(defaultManagedScheduledExecutorServiceAddOp);
                context.getLogger().infof("Default ManagedScheduledExecutorService added to EE subsystem configuration.", new Object[0]);
                taskResultBuilder.addAttribute(AddConcurrencyUtilitiesDefaultConfig.TASK_RESULT_ATTR_MANAGED_SCHEDULED_EXECUTOR_SERVICE, (Object)AddConcurrencyUtilitiesDefaultConfig.DEFAULT_MANAGED_SCHEDULED_EXECUTOR_SERVICE_JNDI_NAME);
                return taskResultBuilder.sucess().build();
            }
        };
    }
}

