/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem;

import java.util.List;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.core.ServerMigrationTaskName;
import org.jboss.migration.core.ServerMigrationTaskResult;
import org.jboss.migration.core.env.Environment;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.wfly10.config.management.SubsystemsManagement;
import org.jboss.migration.wfly10.config.task.subsystem.EnvironmentProperties;
import org.jboss.migration.wfly10.config.task.subsystem.Extension;
import org.jboss.migration.wfly10.config.task.subsystem.WildFly10SubsystemMigrationTaskFactory;

public class WildFly10Subsystem {
    private final String name;
    private final String namespaceWithoutVersion;
    private final Extension extension;
    protected final List<WildFly10SubsystemMigrationTaskFactory> subsystemMigrationTasks;
    protected final ServerMigrationTaskName serverMigrationTaskName;

    public WildFly10Subsystem(String name, String namespaceWithoutVersion, String taskName, List<WildFly10SubsystemMigrationTaskFactory> subsystemMigrationTasks, Extension extension) {
        this.name = name;
        this.namespaceWithoutVersion = namespaceWithoutVersion;
        this.extension = extension;
        this.subsystemMigrationTasks = subsystemMigrationTasks;
        this.serverMigrationTaskName = new ServerMigrationTaskName.Builder(taskName).addAttribute("name", this.getName()).build();
    }

    public Extension getExtension() {
        return this.extension;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespaceWithoutVersion() {
        return this.namespaceWithoutVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WildFly10Subsystem subsystem = (WildFly10Subsystem)o;
        return this.name.equals(subsystem.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public ServerMigrationTask getServerMigrationTask(final SubsystemsManagement subsystemsManagement) {
        if (this.subsystemMigrationTasks == null || this.subsystemMigrationTasks.isEmpty()) {
            return null;
        }
        return new ServerMigrationTask(){

            public ServerMigrationTaskName getName() {
                return WildFly10Subsystem.this.serverMigrationTaskName;
            }

            public ServerMigrationTaskResult run(ServerMigrationTaskContext context) throws Exception {
                if (WildFly10Subsystem.this.skipExecution(context)) {
                    return ServerMigrationTaskResult.SKIPPED;
                }
                ModelNode subsystemConfig = subsystemsManagement.getResource(WildFly10Subsystem.this.name);
                for (WildFly10SubsystemMigrationTaskFactory subsystemMigrationTaskFactory : WildFly10Subsystem.this.subsystemMigrationTasks) {
                    context.execute(subsystemMigrationTaskFactory.getServerMigrationTask(subsystemConfig, WildFly10Subsystem.this, subsystemsManagement));
                }
                return context.hasSucessfulSubtasks() ? ServerMigrationTaskResult.SUCCESS : ServerMigrationTaskResult.SKIPPED;
            }
        };
    }

    protected boolean skipExecution(ServerMigrationTaskContext context) {
        return new TaskEnvironment((Environment)context.getServerMigrationContext().getMigrationEnvironment(), EnvironmentProperties.getSubsystemTaskPropertiesPrefix(this.name)).isSkippedByEnvironment();
    }
}

