/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.core.ServerMigrationTaskName;
import org.jboss.migration.core.ServerMigrationTaskResult;
import org.jboss.migration.wfly10.config.management.SubsystemsManagement;
import org.jboss.migration.wfly10.config.task.subsystem.Extension;
import org.jboss.migration.wfly10.config.task.subsystem.WildFly10Subsystem;

public class WildFly10LegacySubsystem
extends WildFly10Subsystem {
    public WildFly10LegacySubsystem(String name, String namespaceWithoutVersion, Extension extension) {
        super(name, namespaceWithoutVersion, "migrate-subsystem", null, extension);
    }

    protected void processWarnings(List<String> migrationWarnings, SubsystemsManagement subsystemsManagement, ServerMigrationTaskContext context) throws Exception {
    }

    @Override
    public ServerMigrationTask getServerMigrationTask(final SubsystemsManagement subsystemsManagement) {
        final String subsystemName = this.getName();
        return new ServerMigrationTask(){

            public ServerMigrationTaskName getName() {
                return WildFly10LegacySubsystem.this.serverMigrationTaskName;
            }

            public ServerMigrationTaskResult run(ServerMigrationTaskContext context) throws Exception {
                if (WildFly10LegacySubsystem.this.skipExecution(context)) {
                    return ServerMigrationTaskResult.SKIPPED;
                }
                ModelNode subsystemConfig = subsystemsManagement.getResource(subsystemName);
                if (subsystemConfig == null) {
                    return ServerMigrationTaskResult.SKIPPED;
                }
                context.getLogger().debugf("Migrating subsystem %s...", (Object)subsystemName);
                PathAddress address = subsystemsManagement.getResourcePathAddress(subsystemName);
                ModelNode op = Util.createEmptyOperation((String)"migrate", (PathAddress)address);
                ModelNode result = subsystemsManagement.getServerConfiguration().getModelControllerClient().execute(op);
                context.getLogger().debugf("Op result: %s", (Object)result.asString());
                String outcome = result.get("outcome").asString();
                if (!"success".equals(outcome)) {
                    throw new RuntimeException("Subsystem " + subsystemName + " migration failed: " + result.get("migration-error").asString());
                }
                ServerMigrationTaskResult.Builder resultBuilder = new ServerMigrationTaskResult.Builder().sucess();
                ArrayList<String> migrateWarnings = new ArrayList<String>();
                if (result.get("result").hasDefined("migration-warnings")) {
                    for (ModelNode modelNode : result.get("result").get("migration-warnings").asList()) {
                        migrateWarnings.add(modelNode.asString());
                    }
                }
                WildFly10LegacySubsystem.this.processWarnings(migrateWarnings, subsystemsManagement, context);
                if (migrateWarnings.isEmpty()) {
                    context.getLogger().infof("Subsystem %s migrated.", (Object)subsystemName);
                } else {
                    context.getLogger().infof("Subsystem %s migrated with warnings: %s", (Object)subsystemName, migrateWarnings);
                    resultBuilder.addAttribute("migration-warnings", migrateWarnings);
                }
                if (subsystemsManagement.getResourceNames().contains(subsystemName)) {
                    subsystemsManagement.removeResource(subsystemName);
                    context.getLogger().debugf("Subsystem %s removed after migration.", (Object)subsystemName);
                }
                return resultBuilder.build();
            }
        };
    }
}

