/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem;

import java.util.ArrayList;
import java.util.List;
import org.jboss.migration.wfly10.config.task.subsystem.Extension;
import org.jboss.migration.wfly10.config.task.subsystem.WildFly10SubsystemBuilder;
import org.jboss.migration.wfly10.config.task.subsystem.WildFly10SubsystemMigrationTaskFactory;

public class ExtensionBuilder {
    private final List<WildFly10SubsystemBuilder> subsystems = new ArrayList<WildFly10SubsystemBuilder>();
    private final String name;

    public ExtensionBuilder(String name) {
        this.name = name;
    }

    public ExtensionBuilder addSubsystem(WildFly10SubsystemBuilder subsystem) {
        this.subsystems.add(subsystem);
        return this;
    }

    public ExtensionBuilder addSupportedSubsystem(String subsystemName) {
        return this.addSubsystem(subsystemName, "supported-subsystem", null);
    }

    public ExtensionBuilder addSubsystem(String subsystemName, String taskName, WildFly10SubsystemMigrationTaskFactory ... tasks) {
        WildFly10SubsystemBuilder subsystemBuilder = new WildFly10SubsystemBuilder().setName(subsystemName).setTaskName(taskName);
        if (tasks != null) {
            for (WildFly10SubsystemMigrationTaskFactory task : tasks) {
                subsystemBuilder.addTask(task);
            }
        }
        return this.addSubsystem(subsystemBuilder);
    }

    public Extension build() {
        Extension extension = new Extension(this.name);
        for (WildFly10SubsystemBuilder subsystem : this.subsystems) {
            extension.subsystems.add(subsystem.setExtension(extension).build());
        }
        return extension;
    }
}

