/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.core.ServerMigrationTaskName;
import org.jboss.migration.core.ServerMigrationTaskResult;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.wfly10.config.management.SubsystemsManagement;
import org.jboss.migration.wfly10.config.task.subsystem.UpdateSubsystemTaskFactory;

public class AddSubsystem
implements UpdateSubsystemTaskFactory.SubtaskFactory {
    public static final AddSubsystem INSTANCE = new AddSubsystem();

    protected AddSubsystem() {
    }

    @Override
    public ServerMigrationTask getServerMigrationTask(ModelNode config, final UpdateSubsystemTaskFactory subsystem, SubsystemsManagement subsystemsManagement) {
        return new UpdateSubsystemTaskFactory.Subtask(config, subsystem, subsystemsManagement){

            public ServerMigrationTaskName getName() {
                return new ServerMigrationTaskName.Builder("add-subsystem-config").addAttribute("name", subsystem.getName()).build();
            }

            @Override
            protected ServerMigrationTaskResult run(ModelNode config, UpdateSubsystemTaskFactory subsystem2, SubsystemsManagement subsystemsManagement, ServerMigrationTaskContext context, TaskEnvironment taskEnvironment) throws Exception {
                if (config != null) {
                    context.getLogger().infof("Skipped adding subsystem %s, already exists in config.", (Object)subsystem2.getName());
                    return ServerMigrationTaskResult.SKIPPED;
                }
                context.getLogger().debugf("Adding subsystem %s config...", (Object)subsystem2.getName());
                AddSubsystem.this.addSubsystem(subsystem2, subsystemsManagement, context);
                context.getLogger().infof("Subsystem %s config added.", (Object)subsystem2.getName());
                return ServerMigrationTaskResult.SUCCESS;
            }
        };
    }

    protected void addSubsystem(UpdateSubsystemTaskFactory subsystem, SubsystemsManagement subsystemsManagement, ServerMigrationTaskContext context) throws Exception {
        ModelNode op = Util.createAddOperation((PathAddress)subsystemsManagement.getResourcePathAddress(subsystem.getName()));
        subsystemsManagement.getServerConfiguration().executeManagementOperation(op);
    }
}

