/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.core.ServerMigrationTaskName;
import org.jboss.migration.core.ServerMigrationTaskResult;
import org.jboss.migration.wfly10.config.management.ExtensionsManagement;
import org.jboss.migration.wfly10.config.task.executor.ExtensionsManagementSubtaskExecutor;

public class AddExtensionSubtask<S>
implements ExtensionsManagementSubtaskExecutor<S> {
    private final String extensionModule;

    public AddExtensionSubtask(String extensionModule) {
        this.extensionModule = extensionModule;
    }

    @Override
    public void executeSubtasks(S source, final ExtensionsManagement extensionsManagement, ServerMigrationTaskContext context) throws Exception {
        final ServerMigrationTaskName taskName = new ServerMigrationTaskName.Builder("add-extension").addAttribute("name", this.extensionModule).build();
        ServerMigrationTask task = new ServerMigrationTask(){

            public ServerMigrationTaskName getName() {
                return taskName;
            }

            public ServerMigrationTaskResult run(ServerMigrationTaskContext context) throws Exception {
                if (!extensionsManagement.getResourceNames().contains(AddExtensionSubtask.this.extensionModule)) {
                    context.getLogger().debugf("Adding Extension %s...", (Object)AddExtensionSubtask.this.extensionModule);
                    ModelNode op = Util.createAddOperation((PathAddress)extensionsManagement.getResourcePathAddress(AddExtensionSubtask.this.extensionModule));
                    op.get("module").set(AddExtensionSubtask.this.extensionModule);
                    extensionsManagement.getServerConfiguration().executeManagementOperation(op);
                    context.getLogger().infof("Extension %s added.", (Object)AddExtensionSubtask.this.extensionModule);
                    return ServerMigrationTaskResult.SUCCESS;
                }
                context.getLogger().infof("Skipped adding extension %s, already exists in config.", (Object)AddExtensionSubtask.this.extensionModule);
                return ServerMigrationTaskResult.SKIPPED;
            }
        };
        context.execute(task);
    }
}

