/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.migration.core.ParentServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.core.ServerMigrationTaskName;
import org.jboss.migration.core.ServerMigrationTaskResult;
import org.jboss.migration.core.env.SkippableByEnvServerMigrationTask;
import org.jboss.migration.wfly10.config.management.HostConfiguration;
import org.jboss.migration.wfly10.config.management.HostControllerConfiguration;
import org.jboss.migration.wfly10.config.management.HostsManagement;
import org.jboss.migration.wfly10.config.management.impl.EmbeddedHostConfiguration;
import org.jboss.migration.wfly10.config.task.factory.HostConfigurationTaskFactory;
import org.jboss.migration.wfly10.config.task.factory.HostsManagementTaskFactory;
import org.jboss.migration.wfly10.config.task.factory.ManageableServerConfigurationTaskFactory;

public class HostMigration<S>
implements HostsManagementTaskFactory<S> {
    public static final String HOSTS = "hosts";
    public static final String HOST = "host";
    public static final String MIGRATION_REPORT_TASK_ATTR_NAME = "name";
    protected final HostConfigurationProvider hostConfigurationProvider;
    protected final List<HostConfigurationTaskFactory<S>> subtaskFactories;

    protected HostMigration(Builder builder) {
        this.hostConfigurationProvider = builder.hostConfigurationProvider;
        this.subtaskFactories = Collections.unmodifiableList(builder.subtaskFactories);
    }

    protected ServerMigrationTask getResourceSubtask(final String resourceName, final S source, final HostsManagement resourceManagement) throws Exception {
        final ServerMigrationTaskName subtaskName = new ServerMigrationTaskName.Builder(HOST).addAttribute(MIGRATION_REPORT_TASK_ATTR_NAME, resourceName).build();
        return new ServerMigrationTask(){

            public ServerMigrationTaskName getName() {
                return subtaskName;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ServerMigrationTaskResult run(ServerMigrationTaskContext context) throws Exception {
                context.getServerMigrationContext().getConsoleWrapper().printf("%n%n", new Object[0]);
                context.getLogger().infof("Migrating host %s in host configuration %s ...", (Object)resourceName, source);
                HostConfiguration hostConfiguration = HostMigration.this.hostConfigurationProvider.getHostConfiguration(resourceName, resourceManagement.getHostControllerConfiguration());
                hostConfiguration.start();
                try {
                    for (HostConfigurationTaskFactory<Object> hostConfigurationTaskFactory : HostMigration.this.subtaskFactories) {
                        ServerMigrationTask subtask = hostConfigurationTaskFactory.getTask(source, hostConfiguration);
                        if (subtask == null) continue;
                        context.execute(subtask);
                    }
                }
                finally {
                    hostConfiguration.stop();
                    context.getLogger().infof("Migration of host %s in host configuration %s done.", (Object)resourceName, source);
                }
                return context.hasSucessfulSubtasks() ? ServerMigrationTaskResult.SUCCESS : ServerMigrationTaskResult.SKIPPED;
            }
        };
    }

    @Override
    public ServerMigrationTask getTask(final S source, final HostsManagement hostsManagement) throws Exception {
        ServerMigrationTaskName taskName = new ServerMigrationTaskName.Builder(HOSTS).build();
        ParentServerMigrationTask.Builder taskBuilder = new ParentServerMigrationTask.Builder(taskName).eventListener(new ParentServerMigrationTask.EventListener(){

            public void started(ServerMigrationTaskContext context) {
                context.getLogger().infof("Hosts migration starting...", new Object[0]);
            }

            public void done(ServerMigrationTaskContext context) {
                context.getLogger().infof("Hosts migration done.", new Object[0]);
            }
        }).subtask(new ParentServerMigrationTask.SubtaskExecutor(){

            public void executeSubtasks(ServerMigrationTaskContext context) throws Exception {
                for (String resourceName : hostsManagement.getResourceNames()) {
                    ServerMigrationTask subtask = HostMigration.this.getResourceSubtask(resourceName, source, hostsManagement);
                    if (subtask == null) continue;
                    context.execute(subtask);
                }
            }
        });
        return new SkippableByEnvServerMigrationTask((ServerMigrationTask)taskBuilder.build(), taskName.getName() + ".skip");
    }

    public static class Builder<S> {
        private HostConfigurationProvider hostConfigurationProvider;
        private final List<HostConfigurationTaskFactory<S>> subtaskFactories;

        public Builder() {
            this(new EmbeddedHostConfiguration.HostConfigFileMigrationFactory());
        }

        public Builder(HostConfigurationProvider hostConfigurationProvider) {
            this.hostConfigurationProvider = hostConfigurationProvider;
            this.subtaskFactories = new ArrayList<HostConfigurationTaskFactory<S>>();
        }

        public Builder<S> subtask(HostConfigurationTaskFactory<S> subtaskFactory) {
            this.subtaskFactories.add(subtaskFactory);
            return this;
        }

        public Builder<S> subtask(final ManageableServerConfigurationTaskFactory<S, HostConfiguration> subtaskFactory) {
            return this.subtask(new HostConfigurationTaskFactory<S>(){

                @Override
                public ServerMigrationTask getTask(S source, HostConfiguration configuration) throws Exception {
                    return subtaskFactory.getTask(source, configuration);
                }
            });
        }

        public HostMigration<S> build() {
            return new HostMigration(this);
        }
    }

    public static interface HostConfigurationProvider {
        public HostConfiguration getHostConfiguration(String var1, HostControllerConfiguration var2) throws Exception;
    }
}

