/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.management.impl;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.migration.wfly10.WildFly10Server;
import org.jboss.migration.wfly10.config.management.DeploymentsManagement;
import org.jboss.migration.wfly10.config.management.ExtensionsManagement;
import org.jboss.migration.wfly10.config.management.InterfacesManagement;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.ManagementInterfacesManagement;
import org.jboss.migration.wfly10.config.management.SecurityRealmsManagement;
import org.jboss.migration.wfly10.config.management.SocketBindingGroupsManagement;
import org.jboss.migration.wfly10.config.management.StandaloneServerConfiguration;
import org.jboss.migration.wfly10.config.management.SubsystemsManagement;
import org.jboss.migration.wfly10.config.management.impl.AbstractManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.impl.DeploymentsManagementImpl;
import org.jboss.migration.wfly10.config.management.impl.ExtensionsManagementImpl;
import org.jboss.migration.wfly10.config.management.impl.InterfacesManagementImpl;
import org.jboss.migration.wfly10.config.management.impl.ManagementInterfacesManagementImpl;
import org.jboss.migration.wfly10.config.management.impl.SecurityRealmsManagementImpl;
import org.jboss.migration.wfly10.config.management.impl.SocketBindingGroupsManagementImpl;
import org.jboss.migration.wfly10.config.management.impl.SubsystemsManagementImpl;
import org.jboss.migration.wfly10.config.task.ServerConfigurationMigration;
import org.wildfly.core.embedded.EmbeddedProcessFactory;
import org.wildfly.core.embedded.EmbeddedProcessStartException;
import org.wildfly.core.embedded.StandaloneServer;

public class EmbeddedStandaloneServerConfiguration
extends AbstractManageableServerConfiguration
implements StandaloneServerConfiguration {
    private final String config;
    private StandaloneServer standaloneServer;
    private final DeploymentsManagement deploymentsManagement;
    private final ExtensionsManagement extensionsManagement;
    private final InterfacesManagement interfacesManagement;
    private final ManagementInterfacesManagement managementInterfacesManagement;
    private final SecurityRealmsManagement securityRealmsManagement;
    private final SocketBindingGroupsManagement socketBindingGroupsManagement;
    private final SubsystemsManagement subsystemsManagement;

    public EmbeddedStandaloneServerConfiguration(String config, WildFly10Server server) {
        super(server);
        this.config = config;
        this.deploymentsManagement = new DeploymentsManagementImpl(null, this);
        this.extensionsManagement = new ExtensionsManagementImpl(null, (ManageableServerConfiguration)this){

            @Override
            public Set<String> getSubsystems() throws IOException {
                return EmbeddedStandaloneServerConfiguration.this.getSubsystemsManagement().getResourceNames();
            }
        };
        this.subsystemsManagement = new SubsystemsManagementImpl(null, this);
        this.interfacesManagement = new InterfacesManagementImpl(null, this);
        this.socketBindingGroupsManagement = new SocketBindingGroupsManagementImpl(null, this);
        PathAddress managementCoreServicePathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"core-service", (String)"management")});
        this.securityRealmsManagement = new SecurityRealmsManagementImpl(managementCoreServicePathAddress, this);
        this.managementInterfacesManagement = new ManagementInterfacesManagementImpl(managementCoreServicePathAddress, this);
    }

    @Override
    protected ModelControllerClient startConfiguration() {
        String[] cmds = new String[]{"--server-config=" + this.config, "--admin-only"};
        this.standaloneServer = EmbeddedProcessFactory.createStandaloneServer((String)this.getServer().getBaseDir().toString(), null, null, (String[])cmds);
        try {
            this.standaloneServer.start();
        }
        catch (EmbeddedProcessStartException e) {
            throw new RuntimeException(e);
        }
        return this.standaloneServer.getModelControllerClient();
    }

    @Override
    protected void stopConfiguration() {
        this.standaloneServer.stop();
        this.standaloneServer = null;
    }

    @Override
    public DeploymentsManagement getDeploymentsManagement() {
        return this.deploymentsManagement;
    }

    @Override
    public ExtensionsManagement getExtensionsManagement() {
        return this.extensionsManagement;
    }

    @Override
    public InterfacesManagement getInterfacesManagement() {
        return this.interfacesManagement;
    }

    @Override
    public SecurityRealmsManagement getSecurityRealmsManagement() {
        return this.securityRealmsManagement;
    }

    @Override
    public SocketBindingGroupsManagement getSocketBindingGroupsManagement() {
        return this.socketBindingGroupsManagement;
    }

    @Override
    public SubsystemsManagement getSubsystemsManagement() {
        return this.subsystemsManagement;
    }

    @Override
    public ManagementInterfacesManagement getManagementInterfacesManagement() {
        return this.managementInterfacesManagement;
    }

    public static class ConfigFileMigrationFactory
    implements ServerConfigurationMigration.ManageableConfigurationProvider {
        public StandaloneServerConfiguration getManageableConfiguration(Path configFile, WildFly10Server server) {
            return new EmbeddedStandaloneServerConfiguration(configFile.getFileName().toString(), server);
        }
    }
}

